/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.parser.typdep.io;

import com.johnsnowlabs.nlp.annotators.parser.typdep.DependencyInstance;
import com.johnsnowlabs.nlp.annotators.parser.typdep.io.DependencyReader;
import java.io.IOException;
import java.util.ArrayList;

public class ConllUReader
extends DependencyReader {
    private static final String ROOT = "<root>";
    private static final String ROOT_LEMMA = "<root-LEMMA>";
    private static final String ROOT_POS = "<root-POS>";
    private static final String NO_TYPE = "<no-type>";

    @Override
    public DependencyInstance nextInstance() throws IOException {
        ArrayList<String[]> arrayList = this.getFileContentAsArray();
        if (arrayList.isEmpty()) {
            return null;
        }
        int n = arrayList.size();
        String[] stringArray = new String[n + 1];
        String[] stringArray2 = new String[n + 1];
        String[] stringArray3 = new String[n + 1];
        String[] stringArray4 = new String[n + 1];
        String[][] stringArray5 = new String[n + 1][];
        String[] stringArray6 = new String[n + 1];
        int[] nArray = new int[n + 1];
        this.initializeRoot(stringArray, stringArray2, stringArray3, stringArray4, stringArray6, nArray);
        boolean bl = this.parseLines(arrayList, stringArray, stringArray2, stringArray3, stringArray4, stringArray5, stringArray6, nArray);
        if (!bl) {
            stringArray2 = null;
        }
        return new DependencyInstance(stringArray, stringArray2, stringArray3, stringArray4, stringArray5, nArray, stringArray6, null, null);
    }

    private void initializeRoot(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, int[] nArray) {
        stringArray[0] = ROOT;
        stringArray2[0] = ROOT_LEMMA;
        stringArray3[0] = ROOT_POS;
        stringArray4[0] = ROOT_POS;
        stringArray5[0] = NO_TYPE;
        nArray[0] = -1;
    }

    private boolean parseLines(ArrayList<String[]> arrayList, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[][] stringArray5, String[] stringArray6, int[] nArray) {
        boolean bl = false;
        for (int i = 1; i <= arrayList.size(); ++i) {
            String[] stringArray7 = arrayList.get(i - 1);
            String string = stringArray7[0];
            String string2 = stringArray7[1];
            String string3 = stringArray7[2];
            String string4 = stringArray7[3];
            String string5 = stringArray7[4];
            String string6 = stringArray7[5];
            String string7 = stringArray7[6];
            String string8 = stringArray7[7];
            if (this.skipIteration(string, string7, string4, string5)) continue;
            stringArray[i] = string2;
            stringArray2[i] = this.valueAvailable(string3) ? string3 : null;
            bl |= stringArray2[i] != null;
            stringArray3[i] = this.valueAvailable(string4) ? string4 : string5;
            stringArray4[i] = this.valueAvailable(string5) ? string5 : string4;
            stringArray5[i] = this.valueAvailable(string6) ? string6.split("\\|") : null;
            nArray[i] = Integer.parseInt(string7);
            stringArray6[i] = string8;
        }
        return bl;
    }

    private boolean skipIteration(String string, String string2, String string3, String string4) {
        return this.valueIsNotNumber(string) || this.valueIsNotNumber(string2) || !this.valueAvailable(string3) && !this.valueAvailable(string4);
    }

    private boolean valueAvailable(String string) {
        return !string.equals("_");
    }

    private boolean valueIsNotNumber(String string) {
        return !string.matches("\\d+");
    }

    private ArrayList<String[]> getFileContentAsArray() throws IOException {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String string = this.reader.readLine();
        while (string != null && !string.equals("")) {
            int n;
            String string2;
            if (!string.startsWith("#") && !(string2 = string.substring(0, n = string.indexOf(9))).contains(".")) {
                arrayList.add(string.trim().split("\t"));
            }
            string = this.reader.readLine();
        }
        return arrayList;
    }
}

