/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.annotators.similarity;

import com.johnsnowlabs.nlp.AnnotatorApproach;
import com.johnsnowlabs.nlp.AnnotatorType$;
import com.johnsnowlabs.nlp.HasEnableCachingProperties;
import com.johnsnowlabs.nlp.HasFeatures;
import com.johnsnowlabs.nlp.ParamsAndFeaturesWritable;
import com.johnsnowlabs.nlp.annotators.similarity.DocumentSimilarityRankerApproach$;
import com.johnsnowlabs.nlp.annotators.similarity.DocumentSimilarityRankerModel;
import com.johnsnowlabs.nlp.annotators.similarity.DocumentSimilarityUtil$;
import com.johnsnowlabs.nlp.annotators.similarity.IndexedNeighbors;
import com.johnsnowlabs.nlp.annotators.similarity.IndexedNeighborsWithDistance;
import com.johnsnowlabs.nlp.annotators.similarity.NeighborAnnotation;
import com.johnsnowlabs.nlp.annotators.similarity.NeighborsResultSet;
import com.johnsnowlabs.nlp.serialization.ArrayFeature;
import com.johnsnowlabs.nlp.serialization.Feature;
import com.johnsnowlabs.nlp.serialization.MapFeature;
import com.johnsnowlabs.nlp.serialization.SetFeature;
import com.johnsnowlabs.nlp.serialization.StructFeature;
import com.johnsnowlabs.util.spark.SparkUtil$;
import java.io.Serializable;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.feature.BucketedRandomProjectionLSH;
import org.apache.spark.ml.feature.LSHModel;
import org.apache.spark.ml.feature.MinHashLSH;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001\u0002\u001e<\u0001\u0019C\u0001B\u0015\u0001\u0003\u0006\u0004%\te\u0015\u0005\tC\u0002\u0011\t\u0011)A\u0005)\")!\r\u0001C\u0001G\"9a\r\u0001b\u0001\n\u0003:\u0007B\u00028\u0001A\u0003%\u0001\u000eC\u0003c\u0001\u0011\u0005q\u000eC\u0004q\u0001\t\u0007I\u0011I9\t\rY\u0004\u0001\u0015!\u0003s\u0011\u001d9\bA1A\u0005B\u001dDa\u0001\u001f\u0001!\u0002\u0013A\u0007bB=\u0001\u0005\u0004%\tA\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003|\u0011!\t9\u0001\u0001b\u0001\n\u0003Q\bbBA\u0005\u0001\u0001\u0006Ia\u001f\u0005\t\u0003\u0017\u0001!\u0019!C\u0001u\"9\u0011Q\u0002\u0001!\u0002\u0013Y\b\u0002CA\b\u0001\t\u0007I\u0011\u0001>\t\u000f\u0005E\u0001\u0001)A\u0005w\"A\u00111\u0003\u0001C\u0002\u0013\u0005!\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0011B>\t\u0013\u0005]\u0001A1A\u0005\u0002\u0005e\u0001\u0002CA\u001c\u0001\u0001\u0006I!a\u0007\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!1\u0011\u0011\t\u0001\u0005\u0002MC\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0012\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u000fBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002X\u0001!\t!!\u0017\t\u0013\u0005m\u0003A1A\u0005\u0002\u0005u\u0003\u0002CA4\u0001\u0001\u0006I!a\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004\"CA:\u0001\t\u0007I\u0011AA#\u0011!\t)\b\u0001Q\u0001\n\u0005\u001d\u0003bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\n\u0003{\u0002!\u0019!C\u0001\u0003\u007fB\u0001\"a\"\u0001A\u0003%\u0011\u0011\u0011\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\t)\n\u0001C\u0001\u0003/C\u0011\"!'\u0001\u0005\u0004%\t!a \t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u0003Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002$\u0002!\t!a&\t\u0013\u0005\u0015\u0006A1A\u0005\u0002\u0005e\u0001\u0002CAT\u0001\u0001\u0006I!a\u0007\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"1\u0011q\u0016\u0001\u0005\u0002MC\u0011\"!-\u0001\u0005\u0004%\t!!\u0007\t\u0011\u0005M\u0006\u0001)A\u0005\u00037Aq!!.\u0001\t\u0003\t9\f\u0003\u0004\u0002>\u0002!\ta\u0015\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\u0011)\u0001\u0001C!\u0005\u000f9qAa\u0010<\u0011\u0003\u0011\tE\u0002\u0004;w!\u0005!1\t\u0005\u0007E^\"\tA!\u0018\t\u0013\t}s'!A\u0005\n\t\u0005$\u0001\t#pGVlWM\u001c;TS6LG.\u0019:jif\u0014\u0016M\\6fe\u0006\u0003\bO]8bG\"T!\u0001P\u001f\u0002\u0015MLW.\u001b7be&$\u0018P\u0003\u0002?\u007f\u0005Q\u0011M\u001c8pi\u0006$xN]:\u000b\u0005\u0001\u000b\u0015a\u00018ma*\u0011!iQ\u0001\rU>Dgn\u001d8po2\f'm\u001d\u0006\u0002\t\u0006\u00191m\\7\u0004\u0001M\u0019\u0001aR(\u0011\u0007!K5*D\u0001@\u0013\tQuHA\tB]:|G/\u0019;pe\u0006\u0003\bO]8bG\"\u0004\"\u0001T'\u000e\u0003mJ!AT\u001e\u0003;\u0011{7-^7f]R\u001c\u0016.\\5mCJLG/\u001f*b].,'/T8eK2\u0004\"\u0001\u0013)\n\u0005E{$A\u0007%bg\u0016s\u0017M\u00197f\u0007\u0006\u001c\u0007.\u001b8h!J|\u0007/\u001a:uS\u0016\u001c\u0018aA;jIV\tA\u000b\u0005\u0002V=:\u0011a\u000b\u0018\t\u0003/jk\u0011\u0001\u0017\u0006\u00033\u0016\u000ba\u0001\u0010:p_Rt$\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS\u0016A\u0002)sK\u0012,g-\u0003\u0002`A\n11\u000b\u001e:j]\u001eT!!\u0018.\u0002\tULG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0011,\u0007C\u0001'\u0001\u0011\u0015\u00116\u00011\u0001U\u0003-!Wm]2sSB$\u0018n\u001c8\u0016\u0003!\u0004\"!\u001b6\u000e\u0003\u0001I!a\u001b7\u0003\u001b\u0005sgn\u001c;bi>\u0014H+\u001f9f\u0013\tiwH\u0001\fICN|U\u000f\u001e9vi\u0006sgn\u001c;bi>\u0014H+\u001f9f\u00031!Wm]2sSB$\u0018n\u001c8!)\u0005!\u0017aE5oaV$\u0018I\u001c8pi\u0006$xN\u001d+za\u0016\u001cX#\u0001:\u0011\u0007M$\b.D\u0001[\u0013\t)(LA\u0003BeJ\f\u00170\u0001\u000bj]B,H/\u00118o_R\fGo\u001c:UsB,7\u000fI\u0001\u0014_V$\b/\u001e;B]:|G/\u0019;peRK\b/Z\u0001\u0015_V$\b/\u001e;B]:|G/\u0019;peRK\b/\u001a\u0011\u0002%1\u001b\u0006jX%O!V#vlQ(M?:\u000bU*R\u000b\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\tAA[1wC&\u0011q,`\u0001\u0014\u0019NCu,\u0013(Q+R{6i\u0014'`\u001d\u0006kU\tI\u0001\u0014\u0019NCulT+U!V#vlQ(M?:\u000bU*R\u0001\u0015\u0019NCulT+U!V#vlQ(M?:\u000bU*\u0012\u0011\u0002\u001d%sE)\u0012-`\u0007>cuLT!N\u000b\u0006y\u0011J\u0014#F1~\u001bu\nT0O\u00036+\u0005%\u0001\u0005E\u0013N#\u0016IT\"F\u0003%!\u0015j\u0015+B\u001d\u000e+\u0005%\u0001\u0003U\u000bb#\u0016!\u0002+F1R\u0003\u0013\u0001E:j[&d\u0017M]5us6+G\u000f[8e+\t\tY\u0002E\u0003\u0002\u001e\u0005MB+\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003\u0015\u0001\u0018M]1n\u0015\u0011\t)#a\n\u0002\u00055d'\u0002BA\u0015\u0003W\tQa\u001d9be.TA!!\f\u00020\u00051\u0011\r]1dQ\u0016T!!!\r\u0002\u0007=\u0014x-\u0003\u0003\u00026\u0005}!!\u0002)be\u0006l\u0017!E:j[&d\u0017M]5us6+G\u000f[8eA\u0005\u00192/\u001a;TS6LG.\u0019:jiflU\r\u001e5pIR\u0019\u0011.!\u0010\t\r\u0005}r\u00031\u0001U\u0003\u00151\u0018\r\\;f\u0003M9W\r^*j[&d\u0017M]5us6+G\u000f[8e\u0003IqW/\u001c2fe>3g*Z5hQ\n|WO]:\u0016\u0005\u0005\u001d\u0003CBA\u000f\u0003g\tI\u0005E\u0002t\u0003\u0017J1!!\u0014[\u0005\rIe\u000e^\u0001\u0014]Vl'-\u001a:PM:+\u0017n\u001a5c_V\u00148\u000fI\u0001\u0016g\u0016$h*^7cKJ|eMT3jO\"\u0014w.\u001e:t)\rI\u0017Q\u000b\u0005\b\u0003\u007fY\u0002\u0019AA%\u0003U9W\r\u001e(v[\n,'o\u00144OK&<\u0007NY8veN,\"!!\u0013\u0002\u0019\t,8m[3u\u0019\u0016tw\r\u001e5\u0016\u0005\u0005}\u0003CBA\u000f\u0003g\t\t\u0007E\u0002t\u0003GJ1!!\u001a[\u0005\u0019!u.\u001e2mK\u0006i!-^2lKRdUM\\4uQ\u0002\nqb]3u\u0005V\u001c7.\u001a;MK:<G\u000f\u001b\u000b\u0004S\u00065\u0004bBA ?\u0001\u0007\u0011\u0011M\u0001\u0010O\u0016$()^2lKRdUM\\4uQV\u0011\u0011\u0011M\u0001\u000e]Vl\u0007*Y:i)\u0006\u0014G.Z:\u0002\u001d9,X\u000eS1tQR\u000b'\r\\3tA\u0005\u00012/\u001a;Ok6D\u0015m\u001d5UC\ndWm\u001d\u000b\u0004S\u0006m\u0004bBA G\u0001\u0007\u0011\u0011J\u0001\u0011m&\u001c\u0018N\u00197f\t&\u001cH/\u00198dKN,\"!!!\u0011\t\u0005u\u00111Q\u0005\u0005\u0003\u000b\u000byB\u0001\u0007C_>dW-\u00198QCJ\fW.A\twSNL'\r\\3ESN$\u0018M\\2fg\u0002\n1c]3u-&\u001c\u0018N\u00197f\t&\u001cH/\u00198dKN$2![AG\u0011\u001d\tyD\na\u0001\u0003\u001f\u00032a]AI\u0013\r\t\u0019J\u0017\u0002\b\u0005>|G.Z1o\u0003M9W\r\u001e,jg&\u0014G.\u001a#jgR\fgnY3t+\t\ty)A\bjI\u0016tG/\u001b;z%\u0006t7.\u001b8h\u0003AIG-\u001a8uSRL(+\u00198lS:<\u0007%\u0001\ntKRLE-\u001a8uSRL(+\u00198lS:<GcA5\u0002\"\"9\u0011q\b\u0016A\u0002\u0005=\u0015AE4fi&#WM\u001c;jif\u0014\u0016M\\6j]\u001e\f\u0001#Y:SKR\u0014\u0018.\u001a<feF+XM]=\u0002#\u0005\u001c(+\u001a;sS\u00164XM])vKJL\b%A\u0006bgJ+GO]5fm\u0016\u0014HcA5\u0002.\"1\u0011q\b\u0018A\u0002Q\u000b1cZ3u\u0003N\u0014V\r\u001e:jKZ,'/U;fef\f\u0011#Y4he\u0016<\u0017\r^5p]6+G\u000f[8e\u0003I\twm\u001a:fO\u0006$\u0018n\u001c8NKRDw\u000e\u001a\u0011\u0002)M,G/Q4he\u0016<\u0017\r^5p]6+G\u000f[8e)\rI\u0017\u0011\u0018\u0005\u0007\u0003w\u0013\u0004\u0019\u0001+\u0002\u0011M$(/\u0019;fOf\fAcZ3u\u0003\u001e<'/Z4bi&|g.T3uQ>$\u0017!F4fi:+\u0017n\u001a5c_J\u001c(+Z:vYR\u001cV\r\u001e\u000b\u0007\u0003\u0007\fI-a8\u0011\u00071\u000b)-C\u0002\u0002Hn\u0012!CT3jO\"\u0014wN]:SKN,H\u000e^*fi\"9\u00111\u001a\u001bA\u0002\u00055\u0017!B9vKJL\bcB:\u0002P\u0006%\u00131[\u0005\u0004\u0003#T&A\u0002+va2,'\u0007\u0005\u0003\u0002V\u0006mWBAAl\u0015\u0011\tI.a\t\u0002\r1Lg.\u00197h\u0013\u0011\ti.a6\u0003\rY+7\r^8s\u0011\u001d\t\t\u000f\u000ea\u0001\u0003G\f\u0011c]5nS2\f'/\u001b;z\t\u0006$\u0018m]3u!\u0011\t)/a@\u000f\t\u0005\u001d\u0018\u0011 \b\u0005\u0003S\f)P\u0004\u0003\u0002l\u0006Mh\u0002BAw\u0003ct1aVAx\u0013\t\t\t$\u0003\u0003\u0002.\u0005=\u0012\u0002BA\u0015\u0003WIA!a>\u0002(\u0005\u00191/\u001d7\n\t\u0005m\u0018Q`\u0001\ba\u0006\u001c7.Y4f\u0015\u0011\t90a\n\n\t\t\u0005!1\u0001\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!a?\u0002~\u0006)AO]1j]R)1J!\u0003\u0003.!9!1B\u001bA\u0002\t5\u0011!E3nE\u0016$G-\u001b8hg\u0012\u000bG/Y:fiB\"!q\u0002B\u000e!\u0019\u0011\tBa\u0005\u0003\u00185\u0011\u0011Q`\u0005\u0005\u0005+\tiPA\u0004ECR\f7/\u001a;\u0011\t\te!1\u0004\u0007\u0001\t1\u0011iB!\u0003\u0002\u0002\u0003\u0005)\u0011\u0001B\u0010\u0005\ryFEM\t\u0005\u0005C\u00119\u0003E\u0002t\u0005GI1A!\n[\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\u001dB\u0015\u0013\r\u0011YC\u0017\u0002\u0004\u0003:L\b\"\u0003B\u0018kA\u0005\t\u0019\u0001B\u0019\u0003E\u0011XmY;sg&4X\rU5qK2Lg.\u001a\t\u0006g\nM\"qG\u0005\u0004\u0005kQ&AB(qi&|g\u000e\u0005\u0003\u0003:\tmRBAA\u0012\u0013\u0011\u0011i$a\t\u0003\u001bAK\u0007/\u001a7j]\u0016lu\u000eZ3m\u0003\u0001\"unY;nK:$8+[7jY\u0006\u0014\u0018\u000e^=SC:\\WM]!qaJ|\u0017m\u00195\u0011\u00051;4cB\u001c\u0003F\t-#q\u000b\t\u0004g\n\u001d\u0013b\u0001B%5\n1\u0011I\\=SK\u001a\u0004RA!\u0014\u0003T\u0011l!Aa\u0014\u000b\t\tE\u00131E\u0001\u0005kRLG.\u0003\u0003\u0003V\t=#!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004g\ne\u0013b\u0001B.5\na1+\u001a:jC2L'0\u00192mKR\u0011!\u0011I\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003dA\u0019AP!\u001a\n\u0007\t\u001dTP\u0001\u0004PE*,7\r\u001e")
public class DocumentSimilarityRankerApproach
extends AnnotatorApproach<DocumentSimilarityRankerModel>
implements HasEnableCachingProperties {
    private final String uid;
    private final String description;
    private final String[] inputAnnotatorTypes;
    private final String outputAnnotatorType;
    private final String LSH_INPUT_COL_NAME;
    private final String LSH_OUTPUT_COL_NAME;
    private final String INDEX_COL_NAME;
    private final String DISTANCE;
    private final String TEXT;
    private final Param<String> similarityMethod;
    private final Param<Object> numberOfNeighbours;
    private final Param<Object> bucketLength;
    private final Param<Object> numHashTables;
    private final BooleanParam visibleDistances;
    private final BooleanParam identityRanking;
    private final Param<String> asRetrieverQuery;
    private final Param<String> aggregationMethod;
    private final BooleanParam enableCaching;
    private final ArrayBuffer<Feature<?, ?, ?>> features;

    public static MLReader<DocumentSimilarityRankerApproach> read() {
        return DocumentSimilarityRankerApproach$.MODULE$.read();
    }

    public static Object load(String string) {
        return DocumentSimilarityRankerApproach$.MODULE$.load(string);
    }

    @Override
    public boolean getEnableCaching() {
        return HasEnableCachingProperties.getEnableCaching$(this);
    }

    @Override
    public HasEnableCachingProperties setEnableCaching(boolean value) {
        return HasEnableCachingProperties.setEnableCaching$(this, value);
    }

    @Override
    public /* synthetic */ MLWriter com$johnsnowlabs$nlp$ParamsAndFeaturesWritable$$super$write() {
        return DefaultParamsWritable.write$((DefaultParamsWritable)this);
    }

    @Override
    public void onWrite(String path, SparkSession spark) {
        ParamsAndFeaturesWritable.onWrite$(this, path, spark);
    }

    @Override
    public MLWriter write() {
        return ParamsAndFeaturesWritable.write$(this);
    }

    @Override
    public <T> HasFeatures set(ArrayFeature<T> feature, Object value) {
        return HasFeatures.set$((HasFeatures)this, feature, value);
    }

    @Override
    public <T> HasFeatures set(SetFeature<T> feature, Set<T> value) {
        return HasFeatures.set$((HasFeatures)this, feature, value);
    }

    @Override
    public <K, V> HasFeatures set(MapFeature<K, V> feature, Map<K, V> value) {
        return HasFeatures.set$((HasFeatures)this, feature, value);
    }

    @Override
    public <T> HasFeatures set(StructFeature<T> feature, T value) {
        return HasFeatures.set$((HasFeatures)this, feature, value);
    }

    @Override
    public <T> HasFeatures setDefault(ArrayFeature<T> feature, Function0<Object> value) {
        return HasFeatures.setDefault$((HasFeatures)this, feature, value);
    }

    @Override
    public <T> HasFeatures setDefault(SetFeature<T> feature, Function0<Set<T>> value) {
        return HasFeatures.setDefault$((HasFeatures)this, feature, value);
    }

    @Override
    public <K, V> HasFeatures setDefault(MapFeature<K, V> feature, Function0<Map<K, V>> value) {
        return HasFeatures.setDefault$((HasFeatures)this, feature, value);
    }

    @Override
    public <T> HasFeatures setDefault(StructFeature<T> feature, Function0<T> value) {
        return HasFeatures.setDefault$((HasFeatures)this, feature, value);
    }

    @Override
    public <T> Option<Object> get(ArrayFeature<T> feature) {
        return HasFeatures.get$((HasFeatures)this, feature);
    }

    @Override
    public <T> Option<Set<T>> get(SetFeature<T> feature) {
        return HasFeatures.get$((HasFeatures)this, feature);
    }

    @Override
    public <K, V> Option<Map<K, V>> get(MapFeature<K, V> feature) {
        return HasFeatures.get$((HasFeatures)this, feature);
    }

    @Override
    public <T> Option<T> get(StructFeature<T> feature) {
        return HasFeatures.get$((HasFeatures)this, feature);
    }

    @Override
    public <T> Object $$(ArrayFeature<T> feature) {
        return HasFeatures.$$$((HasFeatures)this, feature);
    }

    @Override
    public <T> Set<T> $$(SetFeature<T> feature) {
        return HasFeatures.$$$((HasFeatures)this, feature);
    }

    @Override
    public <K, V> Map<K, V> $$(MapFeature<K, V> feature) {
        return HasFeatures.$$$((HasFeatures)this, feature);
    }

    @Override
    public <T> T $$(StructFeature<T> feature) {
        return (T)HasFeatures.$$$((HasFeatures)this, feature);
    }

    @Override
    public BooleanParam enableCaching() {
        return this.enableCaching;
    }

    @Override
    public void com$johnsnowlabs$nlp$HasEnableCachingProperties$_setter_$enableCaching_$eq(BooleanParam x$1) {
        this.enableCaching = x$1;
    }

    @Override
    public ArrayBuffer<Feature<?, ?, ?>> features() {
        return this.features;
    }

    @Override
    public void com$johnsnowlabs$nlp$HasFeatures$_setter_$features_$eq(ArrayBuffer<Feature<?, ?, ?>> x$1) {
        this.features = x$1;
    }

    public String uid() {
        return this.uid;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String[] inputAnnotatorTypes() {
        return this.inputAnnotatorTypes;
    }

    @Override
    public String outputAnnotatorType() {
        return this.outputAnnotatorType;
    }

    public String LSH_INPUT_COL_NAME() {
        return this.LSH_INPUT_COL_NAME;
    }

    public String LSH_OUTPUT_COL_NAME() {
        return this.LSH_OUTPUT_COL_NAME;
    }

    public String INDEX_COL_NAME() {
        return this.INDEX_COL_NAME;
    }

    public String DISTANCE() {
        return this.DISTANCE;
    }

    public String TEXT() {
        return this.TEXT;
    }

    public Param<String> similarityMethod() {
        return this.similarityMethod;
    }

    public DocumentSimilarityRankerApproach setSimilarityMethod(String value) {
        return (DocumentSimilarityRankerApproach)this.set(this.similarityMethod(), value);
    }

    public String getSimilarityMethod() {
        return (String)this.$(this.similarityMethod());
    }

    public Param<Object> numberOfNeighbours() {
        return this.numberOfNeighbours;
    }

    public DocumentSimilarityRankerApproach setNumberOfNeighbours(int value) {
        return (DocumentSimilarityRankerApproach)this.set(this.numberOfNeighbours(), BoxesRunTime.boxToInteger((int)value));
    }

    public int getNumberOfNeighbours() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.numberOfNeighbours()));
    }

    public Param<Object> bucketLength() {
        return this.bucketLength;
    }

    public DocumentSimilarityRankerApproach setBucketLength(double value) {
        return (DocumentSimilarityRankerApproach)this.set(this.bucketLength(), BoxesRunTime.boxToDouble((double)value));
    }

    public double getBucketLength() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.bucketLength()));
    }

    public Param<Object> numHashTables() {
        return this.numHashTables;
    }

    public DocumentSimilarityRankerApproach setNumHashTables(int value) {
        return (DocumentSimilarityRankerApproach)this.set(this.numHashTables(), BoxesRunTime.boxToInteger((int)value));
    }

    public BooleanParam visibleDistances() {
        return this.visibleDistances;
    }

    public DocumentSimilarityRankerApproach setVisibleDistances(boolean value) {
        return (DocumentSimilarityRankerApproach)this.set((Param)this.visibleDistances(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public boolean getVisibleDistances() {
        return BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.visibleDistances()));
    }

    public BooleanParam identityRanking() {
        return this.identityRanking;
    }

    public DocumentSimilarityRankerApproach setIdentityRanking(boolean value) {
        return (DocumentSimilarityRankerApproach)this.set((Param)this.identityRanking(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public boolean getIdentityRanking() {
        return BoxesRunTime.unboxToBoolean((Object)this.$((Param)this.identityRanking()));
    }

    public Param<String> asRetrieverQuery() {
        return this.asRetrieverQuery;
    }

    public DocumentSimilarityRankerApproach asRetriever(String value) {
        return (DocumentSimilarityRankerApproach)this.set(this.asRetrieverQuery(), value);
    }

    public String getAsRetrieverQuery() {
        return (String)this.$(this.asRetrieverQuery());
    }

    public Param<String> aggregationMethod() {
        return this.aggregationMethod;
    }

    public DocumentSimilarityRankerApproach setAggregationMethod(String strategy) {
        DocumentSimilarityRankerApproach documentSimilarityRankerApproach;
        String string = strategy.toLowerCase();
        if ("average".equals(string)) {
            documentSimilarityRankerApproach = (DocumentSimilarityRankerApproach)this.set(this.aggregationMethod(), "AVERAGE");
        } else if ("first".equals(string)) {
            documentSimilarityRankerApproach = (DocumentSimilarityRankerApproach)this.set(this.aggregationMethod(), "FIRST");
        } else if ("max".equals(string)) {
            documentSimilarityRankerApproach = (DocumentSimilarityRankerApproach)this.set(this.aggregationMethod(), "MAX");
        } else {
            throw new MatchError((Object)"aggregationMethod must be AVERAGE, FIRST or MAX");
        }
        return documentSimilarityRankerApproach;
    }

    public String getAggregationMethod() {
        return (String)this.$(this.aggregationMethod());
    }

    public NeighborsResultSet getNeighborsResultSet(Tuple2<Object, Vector> query, Dataset<Row> similarityDataset) {
        NeighborsResultSet neighborsResultSet;
        MinHashLSH minHashLSH;
        String string = (String)this.$(this.similarityMethod());
        if ("brp".equals(string)) {
            minHashLSH = new BucketedRandomProjectionLSH().setBucketLength(BoxesRunTime.unboxToDouble((Object)this.$(this.bucketLength()))).setNumHashTables(BoxesRunTime.unboxToInt((Object)this.$(this.numHashTables()))).setInputCol(this.LSH_INPUT_COL_NAME()).setOutputCol(this.LSH_OUTPUT_COL_NAME());
        } else if ("mh".equals(string)) {
            minHashLSH = new MinHashLSH().setNumHashTables(BoxesRunTime.unboxToInt((Object)this.$(this.numHashTables()))).setInputCol(this.LSH_INPUT_COL_NAME()).setOutputCol(this.LSH_OUTPUT_COL_NAME());
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append(this.$(this.similarityMethod())).append(" is not a valid value.").toString());
        }
        MinHashLSH lsh = minHashLSH;
        LSHModel model = lsh.fit(similarityDataset);
        Tuple2<Object, Vector> tuple2 = query;
        if (tuple2 != null) {
            int index = tuple2._1$mcI$sp();
            Vector queryVector = (Vector)tuple2._2();
            Dataset _similarityDataset = this.getIdentityRanking() ? similarityDataset : similarityDataset.where(functions$.MODULE$.col("index").$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)index)));
            Dataset similarRankedDocs = model.approxNearestNeighbors(_similarityDataset, queryVector, this.getNumberOfNeighbours());
            if (this.getVisibleDistances()) {
                Tuple2[] rankedNeighboursWithDistances = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])similarRankedDocs.select(this.INDEX_COL_NAME(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.DISTANCE()})).collect())).map((Function1 & Serializable & scala.Serializable)row -> new Tuple2.mcID.sp(row.getInt(0), row.getDouble(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                neighborsResultSet = new NeighborsResultSet((Tuple2<Object, NeighborAnnotation>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)new IndexedNeighborsWithDistance(rankedNeighboursWithDistances)));
            } else {
                int[] rankedNeighbours = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])similarRankedDocs.select(this.INDEX_COL_NAME(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getInt(0)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                neighborsResultSet = new NeighborsResultSet((Tuple2<Object, NeighborAnnotation>)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)new IndexedNeighbors(rankedNeighbours)));
            }
        } else {
            throw new IllegalArgumentException("asRetrieverQuery is not of type (Int, DenseVector)");
        }
        NeighborsResultSet neighborsResultSet2 = neighborsResultSet;
        return neighborsResultSet2;
    }

    @Override
    public DocumentSimilarityRankerModel train(Dataset<?> embeddingsDataset, Option<PipelineModel> recursivePipeline) {
        Dataset dataset;
        String inputEmbeddingsColumn = new StringBuilder(11).append(SparkUtil$.MODULE$.retrieveColumnName(embeddingsDataset, AnnotatorType$.MODULE$.SENTENCE_EMBEDDINGS())).append(".embeddings").toString();
        String string = this.getAggregationMethod();
        if ("AVERAGE".equals(string)) {
            dataset = embeddingsDataset.withColumn(String.valueOf(this.LSH_INPUT_COL_NAME()), DocumentSimilarityUtil$.MODULE$.averageAggregation().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputEmbeddingsColumn)})));
        } else if ("FIRST".equals(string)) {
            dataset = embeddingsDataset.withColumn(String.valueOf(this.LSH_INPUT_COL_NAME()), DocumentSimilarityUtil$.MODULE$.firstEmbeddingAggregation().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputEmbeddingsColumn)})));
        } else if ("MAX".equals(string)) {
            dataset = embeddingsDataset.withColumn(String.valueOf(this.LSH_INPUT_COL_NAME()), DocumentSimilarityUtil$.MODULE$.maxAggregation().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputEmbeddingsColumn)})));
        } else {
            throw new MatchError((Object)string);
        }
        Dataset similarityDataset = dataset;
        Dataset similarityDatasetWithHashIndex = similarityDataset.withColumn(this.INDEX_COL_NAME(), DocumentSimilarityUtil$.MODULE$.mh3UDF().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.TEXT())})));
        Tuple2[] indexedVectorTuples = (Tuple2[])similarityDatasetWithHashIndex.select(this.INDEX_COL_NAME(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.LSH_INPUT_COL_NAME()})).rdd().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x.getAs(this.INDEX_COL_NAME()), x.getAs(this.LSH_INPUT_COL_NAME())), ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        String asRetrieverQuery2 = this.getAsRetrieverQuery();
        Map similarityMappings = asRetrieverQuery2.isEmpty() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexedVectorTuples)).map((Function1 & Serializable & scala.Serializable)query -> this.getNeighborsResultSet((Tuple2<Object, Vector>)query, (Dataset<Row>)similarityDatasetWithHashIndex), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NeighborsResultSet.class))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.result(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()) : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])similarityDatasetWithHashIndex.where(functions$.MODULE$.col("text").$eq$eq$eq((Object)asRetrieverQuery2)).select(this.INDEX_COL_NAME(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.LSH_INPUT_COL_NAME()})).rdd().map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x.getAs(this.INDEX_COL_NAME()), x.getAs(this.LSH_INPUT_COL_NAME())), ClassTag$.MODULE$.apply(Tuple2.class)).collect())).map((Function1 & Serializable & scala.Serializable)asRetrieverQuery -> this.getNeighborsResultSet((Tuple2<Object, Vector>)asRetrieverQuery, (Dataset<Row>)similarityDatasetWithHashIndex), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NeighborsResultSet.class))))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.result(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new DocumentSimilarityRankerModel().setSimilarityMappings((Map<String, Map<Object, NeighborAnnotation>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"similarityMappings"), (Object)similarityMappings)}))));
    }

    public DocumentSimilarityRankerApproach(String uid) {
        this.uid = uid;
        HasFeatures.$init$(this);
        ParamsAndFeaturesWritable.$init$(this);
        HasEnableCachingProperties.$init$(this);
        this.description = "LSH based document similarity annotator";
        this.inputAnnotatorTypes = (String[])((Object[])new String[]{AnnotatorType$.MODULE$.SENTENCE_EMBEDDINGS()});
        this.outputAnnotatorType = AnnotatorType$.MODULE$.DOC_SIMILARITY_RANKINGS();
        this.LSH_INPUT_COL_NAME = "features";
        this.LSH_OUTPUT_COL_NAME = "hashes";
        this.INDEX_COL_NAME = "index";
        this.DISTANCE = "distCol";
        this.TEXT = "text";
        this.similarityMethod = new Param((Identifiable)this, "similarityMethod", new StringOps(Predef$.MODULE$.augmentString("The similarity method used to calculate the neighbours.\n      |(Default: `\"brp\"`, Bucketed Random Projection for Euclidean Distance)\n      |")).stripMargin());
        this.numberOfNeighbours = new Param((Identifiable)this, "numberOfNeighbours", "The number of neighbours the model will return for each document (Default:`\"10\"`)");
        this.bucketLength = new Param((Identifiable)this, "bucketLength", new StringOps(Predef$.MODULE$.augmentString("The bucket length that controls the average size of hash buckets.\n      |A larger bucket length (i.e., fewer buckets) increases the probability of features being hashed\n      |to the same bucket (increasing the numbers of true and false positives)\n      |")).stripMargin());
        this.numHashTables = new Param((Identifiable)this, "numHashTables", new StringOps(Predef$.MODULE$.augmentString("number of hash tables, where increasing number of hash tables lowers the false negative rate,\n      |and decreasing it improves the running performance.\n      |")).stripMargin());
        this.visibleDistances = new BooleanParam((Identifiable)this, "visibleDistances", "Whether to set visibleDistances in ranking output (Default: `false`)");
        this.identityRanking = new BooleanParam((Identifiable)this, "identityRanking", "Whether to include identity in ranking result set. Useful for debug. (Default: `false`)");
        this.asRetrieverQuery = new Param((Identifiable)this, "asRetrieverQuery", "Whether to set the model as retriever RAG with a specific query string. (Default: `empty`)");
        this.aggregationMethod = new Param((Identifiable)this, "aggregationMethod", "Specifies the method used to aggregate multiple sentence embeddings into a single vector representation.");
        this.setDefault((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.similarityMethod().$minus$greater((Object)"brp"), this.numberOfNeighbours().$minus$greater((Object)BoxesRunTime.boxToInteger((int)10)), this.bucketLength().$minus$greater((Object)BoxesRunTime.boxToDouble((double)2.0)), this.numHashTables().$minus$greater((Object)BoxesRunTime.boxToInteger((int)3)), this.visibleDistances().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), this.identityRanking().$minus$greater((Object)BoxesRunTime.boxToBoolean((boolean)false)), this.asRetrieverQuery().$minus$greater((Object)""), this.aggregationMethod().$minus$greater((Object)"AVERAGE")}));
    }

    public DocumentSimilarityRankerApproach() {
        this(Identifiable$.MODULE$.randomUID("DocumentSimilarityRankerApproach"));
    }
}

