/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.nlp.pretrained;

import com.amazonaws.services.s3.model.S3Object;
import com.johnsnowlabs.client.CloudResources$;
import com.johnsnowlabs.client.aws.AWSGateway;
import com.johnsnowlabs.client.aws.AWSGateway$;
import com.johnsnowlabs.client.util.CloudHelper$;
import com.johnsnowlabs.nlp.pretrained.RepositoryMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceDownloader;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata;
import com.johnsnowlabs.nlp.pretrained.ResourceMetadata$;
import com.johnsnowlabs.nlp.pretrained.ResourceRequest;
import com.johnsnowlabs.nlp.pretrained.S3ResourceDownloader$;
import com.johnsnowlabs.util.FileHelper$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\f\u0019\u0001\u0005B\u0001\u0002\f\u0001\u0003\u0002\u0013\u0006I!\f\u0005\tw\u0001\u0011\t\u0011*A\u0005[!AA\b\u0001B\u0001J\u0003%Q\u0006\u0003\u0005>\u0001\t\u0005I\u0015!\u0003.\u0011!q\u0004A!A!\u0002\u0013\u0001\u0004\"B \u0001\t\u0003\u0001\u0005bB$\u0001\u0005\u0004%I\u0001\u0013\u0005\u0007)\u0002\u0001\u000b\u0011B%\t\u000fU\u0003!\u0019!C\u0001-\"11\r\u0001Q\u0001\n]C\u0001\u0002\u001a\u0001\t\u0006\u0004%\t!\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\u0006}\u0002!\ta \u0005\b\u0003#\u0001A\u0011IA\n\u0011\u001d\tI\u0002\u0001C\u0001\u00037Aq!!\u0007\u0001\t\u0003\tI\u0003C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H\u001dI\u0011\u0011\u000b\r\u0002\u0002#\u0005\u00111\u000b\u0004\t/a\t\t\u0011#\u0001\u0002V!1q\b\u0006C\u0001\u0003/B\u0011\"!\u0017\u0015#\u0003%\t!a\u0017\u0003)M\u001b$+Z:pkJ\u001cW\rR8x]2|\u0017\rZ3s\u0015\tI\"$\u0001\u0006qe\u0016$(/Y5oK\u0012T!a\u0007\u000f\u0002\u00079d\u0007O\u0003\u0002\u001e=\u0005a!n\u001c5og:|w\u000f\\1cg*\tq$A\u0002d_6\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015+\u001b\u0005A\u0012BA\u0016\u0019\u0005I\u0011Vm]8ve\u000e,Gi\\<oY>\fG-\u001a:\u0002\r\t,8m[3u!\r\u0019c\u0006M\u0005\u0003_\u0011\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003car!A\r\u001c\u0011\u0005M\"S\"\u0001\u001b\u000b\u0005U\u0002\u0013A\u0002\u001fs_>$h(\u0003\u00028I\u00051\u0001K]3eK\u001aL!!\u000f\u001e\u0003\rM#(/\u001b8h\u0015\t9D%\u0001\u0004tgA\u000bG\u000f[\u0001\fG\u0006\u001c\u0007.\u001a$pY\u0012,'/A\bde\u0016$WM\u001c;jC2\u001cH+\u001f9f\u0003\u0019\u0011XmZ5p]\u00061A(\u001b8jiz\"b!\u0011\"D\t\u00163\u0005CA\u0015\u0001\u0011\u0019ac\u0001\"a\u0001[!11H\u0002CA\u00025Ba\u0001\u0010\u0004\u0005\u0002\u0004i\u0003BB\u001f\u0007\t\u0003\u0007Q\u0006C\u0004?\rA\u0005\t\u0019\u0001\u0019\u0002'I,\u0007o\u001c$pY\u0012,'OM'fi\u0006$\u0017\r^1\u0016\u0003%\u0003BAS(1#6\t1J\u0003\u0002M\u001b\u00069Q.\u001e;bE2,'B\u0001(%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003!.\u00131!T1q!\tI#+\u0003\u0002T1\t\u0011\"+\u001a9pg&$xN]=NKR\fG-\u0019;b\u0003Q\u0011X\r]8G_2$WM\u001d\u001aNKR\fG-\u0019;bA\u0005I1-Y2iKB\u000bG\u000f[\u000b\u0002/B\u0011\u0001,Y\u0007\u00023*\u0011!lW\u0001\u0003MNT!\u0001X/\u0002\r!\fGm\\8q\u0015\tqv,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0006\u0019qN]4\n\u0005\tL&\u0001\u0002)bi\"\f!bY1dQ\u0016\u0004\u0016\r\u001e5!\u0003)\two]$bi\u0016<\u0018-_\u000b\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\u0004C^\u001c(BA6\u001d\u0003\u0019\u0019G.[3oi&\u0011Q\u000e\u001b\u0002\u000b\u0003^\u001bv)\u0019;fo\u0006L\u0018A\u00063po:dw.\u00193NKR\fG-\u0019;b\u0013\u001atU-\u001a3\u0015\u0005Ad\bcA9ws:\u0011!\u000f\u001e\b\u0003gML\u0011!J\u0005\u0003k\u0012\nq\u0001]1dW\u0006<W-\u0003\u0002xq\n!A*[:u\u0015\t)H\u0005\u0005\u0002*u&\u00111\u0010\u0007\u0002\u0011%\u0016\u001cx.\u001e:dK6+G/\u00193bi\u0006DQ! \u0007A\u0002A\naAZ8mI\u0016\u0014\u0018a\u0003:fg>dg/\u001a'j].$B!!\u0001\u0002\bA!1%a\u0001z\u0013\r\t)\u0001\n\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005%Q\u00021\u0001\u0002\f\u00059!/Z9vKN$\bcA\u0015\u0002\u000e%\u0019\u0011q\u0002\r\u0003\u001fI+7o\\;sG\u0016\u0014V-];fgR\f\u0001\u0002Z8x]2|\u0017\r\u001a\u000b\u0005\u0003+\t9\u0002\u0005\u0003$\u0003\u0007\u0001\u0004bBA\u0005\u001d\u0001\u0007\u00111B\u0001\u0015I><h\u000e\\8bI\u0006sG-\u00168{SB4\u0015\u000e\\3\u0015\u0011\u0005U\u0011QDA\u0011\u0003KAa!a\b\u0010\u0001\u00049\u0016a\u00043fgRLg.\u0019;j_:4\u0015\u000e\\3\t\r\u0005\rr\u00021\u0001z\u0003!\u0011Xm]8ve\u000e,\u0007BBA\u0014\u001f\u0001\u0007\u0001'\u0001\u0006tg\u0019KG.\u001a)bi\"$b!!\u0006\u0002,\u00055\u0002BBA\u0014!\u0001\u0007\u0001\u0007C\u0005\u00020A\u0001\n\u00111\u0001\u00022\u0005)QO\u001c>jaB\u00191%a\r\n\u0007\u0005UBEA\u0004C_>dW-\u00198\u0002\u001f\u001d,G\u000fR8x]2|\u0017\rZ*ju\u0016$B!a\u000f\u0002DA)1%a\u0001\u0002>A\u00191%a\u0010\n\u0007\u0005\u0005CE\u0001\u0003M_:<\u0007bBA\u0005#\u0001\u0007\u00111B\u0001\u000bG2,\u0017M]\"bG\",G\u0003BA%\u0003\u001f\u00022aIA&\u0013\r\ti\u0005\n\u0002\u0005+:LG\u000fC\u0004\u0002\nI\u0001\r!a\u0003\u0002)M\u001b$+Z:pkJ\u001cW\rR8x]2|\u0017\rZ3s!\tICc\u0005\u0002\u0015EQ\u0011\u00111K\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u#f\u0001\u0019\u0002`-\u0012\u0011\u0011\r\t\u0005\u0003G\ni'\u0004\u0002\u0002f)!\u0011qMA5\u0003%)hn\u00195fG.,GMC\u0002\u0002l\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty'!\u001a\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class S3ResourceDownloader
implements ResourceDownloader {
    private AWSGateway awsGateway;
    private final Function0<String> bucket;
    private final Function0<String> s3Path;
    private final Function0<String> credentialsType;
    private final String region;
    private final Map<String, RepositoryMetadata> repoFolder2Metadata;
    private final Path cachePath;
    private final FileSystem fileSystem;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$5() {
        return S3ResourceDownloader$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public boolean downloadAndUnzipFile$default$2() {
        return ResourceDownloader.downloadAndUnzipFile$default$2$(this);
    }

    @Override
    public FileSystem fileSystem() {
        return this.fileSystem;
    }

    @Override
    public void com$johnsnowlabs$nlp$pretrained$ResourceDownloader$_setter_$fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    private Map<String, RepositoryMetadata> repoFolder2Metadata() {
        return this.repoFolder2Metadata;
    }

    public Path cachePath() {
        return this.cachePath;
    }

    private AWSGateway awsGateway$lzycompute() {
        S3ResourceDownloader s3ResourceDownloader = this;
        synchronized (s3ResourceDownloader) {
            if (!this.bitmap$0) {
                String x$1 = this.region;
                String x$2 = (String)this.credentialsType.apply();
                String x$3 = AWSGateway$.MODULE$.$lessinit$greater$default$1();
                String x$4 = AWSGateway$.MODULE$.$lessinit$greater$default$2();
                String x$5 = AWSGateway$.MODULE$.$lessinit$greater$default$3();
                String x$6 = AWSGateway$.MODULE$.$lessinit$greater$default$4();
                this.awsGateway = new AWSGateway(x$3, x$4, x$5, x$6, x$1, x$2);
                this.bitmap$0 = true;
            }
        }
        return this.awsGateway;
    }

    public AWSGateway awsGateway() {
        return !this.bitmap$0 ? this.awsGateway$lzycompute() : this.awsGateway;
    }

    @Override
    public List<ResourceMetadata> downloadMetadataIfNeed(String folder) {
        List<ResourceMetadata> list;
        boolean needToRefresh;
        Option lastMetadataState = this.repoFolder2Metadata().get((Object)folder);
        String metadataFilePath = this.awsGateway().getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.s3Path.apply(), folder, "metadata.json"}));
        S3Object metadataObject = this.awsGateway().client().getObject((String)this.bucket.apply(), metadataFilePath);
        Date lastModifiedTimeInS3 = metadataObject.getObjectMetadata().getLastModified();
        boolean bl = needToRefresh = lastMetadataState.isEmpty() || ((RepositoryMetadata)lastMetadataState.get()).lastModified().before(lastModifiedTimeInS3);
        if (!needToRefresh) {
            metadataObject.close();
            list = ((RepositoryMetadata)lastMetadataState.get()).metadata();
        } else {
            List<ResourceMetadata> metadata = ResourceMetadata$.MODULE$.readResources((InputStream)metadataObject.getObjectContent());
            metadataObject.close();
            this.repoFolder2Metadata().update((Object)folder, (Object)new RepositoryMetadata(folder, lastModifiedTimeInS3, Date.from(Instant.now()), metadata));
            list = metadata;
        }
        return list;
    }

    public Option<ResourceMetadata> resolveLink(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        return ResourceMetadata$.MODULE$.resolveResource(metadata, request);
    }

    @Override
    public Option<String> download(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Option<String> option;
            String s3FilePath = this.awsGateway().getS3File((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)$this.s3Path.apply(), request.folder(), resource.fileName()}));
            if (!this.awsGateway().doesS3ObjectExist((String)$this.bucket.apply(), s3FilePath)) {
                option = None$.MODULE$;
            } else {
                Option<String> option2;
                String sourceS3URI = new StringBuilder(7).append("s3a://").append($this.bucket.apply()).append("/").append(s3FilePath).toString();
                String zipFile = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceS3URI.split("/"))).last();
                String modelName = zipFile.substring(0, zipFile.indexOf(".zip"));
                String string = this.cachePath().toString();
                if (CloudHelper$.MODULE$.isCloudPath(string)) {
                    option2 = CloudResources$.MODULE$.downloadModelFromCloud(this.awsGateway(), this.cachePath().toString(), modelName, sourceS3URI);
                } else {
                    Path destinationFile = new Path(this.cachePath().toString(), resource.fileName());
                    option2 = this.downloadAndUnzipFile(destinationFile, (ResourceMetadata)resource, s3FilePath);
                }
                option = option2;
            }
            return option;
        });
    }

    public Option<String> downloadAndUnzipFile(Path destinationFile, ResourceMetadata resource, String s3FilePath) {
        Some some;
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(resource.fileName(), "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            this.awsGateway().getS3Object((String)this.bucket.apply(), s3FilePath, tmpFile);
            if (!resource.checksum().equals("")) {
                Predef$.MODULE$.require(FileHelper$.MODULE$.generateChecksum(tmpFileName).equals(resource.checksum()), (Function0 & Serializable & scala.Serializable)() -> "Checksum validation failed!");
            }
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (resource.isZipped()) {
            Object object;
            if (!this.fileSystem().exists(new Path(splitPath))) {
                ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
                byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
                ZipEntry entry = zis.getNextEntry();
                String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path entryName = new Path(splitPath, entry.getName());
                        FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                        int bytesRead = zis.read(buf, 0, 1024);
                        while (bytesRead > -1) {
                            outputStream.write(buf, 0, bytesRead);
                            bytesRead = zis.read(buf, 0, 1024);
                        }
                        outputStream.close();
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.close();
                object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
            } else {
                object = BoxedUnit.UNIT;
            }
            some = new Some((Object)splitPath);
        } else {
            some = new Some((Object)destinationFile.getName());
        }
        return some;
    }

    @Override
    public Option<String> downloadAndUnzipFile(String s3FilePath, boolean unzip) {
        Object object;
        String newS3FilePath = CloudHelper$.MODULE$.isS3Path(s3FilePath) ? (String)CloudHelper$.MODULE$.parseS3URI(s3FilePath, CloudHelper$.MODULE$.parseS3URI$default$2())._2() : s3FilePath;
        String s3File = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newS3FilePath.split("/"))).last();
        Path destinationFile = new Path(new StringBuilder(1).append(this.cachePath().toString()).append("/").append(s3File).toString());
        String splitPath = destinationFile.toString().substring(0, destinationFile.toString().length() - 4);
        if (!this.fileSystem().exists(destinationFile) && !this.fileSystem().exists(new Path(splitPath))) {
            String tmpFileName = ((Object)Files.createTempFile(s3File, "", new FileAttribute[0])).toString();
            File tmpFile = new File(tmpFileName);
            String newStrfilePath = newS3FilePath;
            String mybucket = (String)this.bucket.apply();
            this.awsGateway().getS3Object(mybucket, newStrfilePath, tmpFile);
            this.fileSystem().moveFromLocalFile(new Path(tmpFile.toString()), destinationFile);
        }
        if (unzip) {
            if (!this.fileSystem().exists(new Path(splitPath))) {
                ZipInputStream zis = new ZipInputStream((InputStream)this.fileSystem().open(destinationFile));
                byte[] buf = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
                ZipEntry entry = zis.getNextEntry();
                String string = destinationFile.toString().substring(destinationFile.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> "Not a zip file.");
                while (entry != null) {
                    if (!entry.isDirectory()) {
                        Path entryName = new Path(splitPath, entry.getName());
                        FSDataOutputStream outputStream = this.fileSystem().create(entryName);
                        int bytesRead = zis.read(buf, 0, 1024);
                        while (bytesRead > -1) {
                            outputStream.write(buf, 0, bytesRead);
                            bytesRead = zis.read(buf, 0, 1024);
                        }
                        outputStream.close();
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
                zis.close();
                object = BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(destinationFile, true));
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return new Some((Object)splitPath);
    }

    @Override
    public Option<Object> getDownloadSize(ResourceRequest request) {
        Option<ResourceMetadata> link = this.resolveLink(request);
        return link.flatMap((Function1 & Serializable & scala.Serializable)resource -> this.awsGateway().getS3DownloadSize((String)$this.s3Path.apply(), request.folder(), resource.fileName(), (String)$this.bucket.apply()));
    }

    @Override
    public void clearCache(ResourceRequest request) {
        List<ResourceMetadata> metadata = this.downloadMetadataIfNeed(request.folder());
        Option<ResourceMetadata> resources = ResourceMetadata$.MODULE$.resolveResource(metadata, request);
        resources.foreach((Function1 & Serializable & scala.Serializable)resource -> {
            Object object;
            Path fileName = new Path(this.cachePath().toString(), resource.fileName());
            Object object2 = this.fileSystem().exists(fileName) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(fileName, true)) : BoxedUnit.UNIT;
            if (resource.isZipped()) {
                String string = fileName.toString().substring(fileName.toString().length() - 4);
                String string2 = ".zip";
                Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
                String unzipped = fileName.toString().substring(0, fileName.toString().length() - 4);
                Path unzippedFile = new Path(unzipped);
                object = this.fileSystem().exists(unzippedFile) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(unzippedFile, true)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public S3ResourceDownloader(Function0<String> bucket, Function0<String> s3Path, Function0<String> cacheFolder, Function0<String> credentialsType, String region) {
        this.bucket = bucket;
        this.s3Path = s3Path;
        this.credentialsType = credentialsType;
        this.region = region;
        ResourceDownloader.$init$(this);
        this.repoFolder2Metadata = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.cachePath = new Path((String)cacheFolder.apply());
        Object object = !CloudHelper$.MODULE$.isCloudPath((String)cacheFolder.apply()) && !this.fileSystem().exists(this.cachePath()) ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().mkdirs(this.cachePath())) : BoxedUnit.UNIT;
    }
}

