/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.reader.util;

import com.johnsnowlabs.nlp.annotators.cleaners.util.CleanerHelper$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class TextParser$ {
    public static TextParser$ MODULE$;
    private final Regex eBulletPattern;
    private final Regex unicodeBulletsPattern;

    static {
        new TextParser$();
    }

    private Regex eBulletPattern() {
        return this.eBulletPattern;
    }

    private Regex unicodeBulletsPattern() {
        return this.unicodeBulletsPattern;
    }

    public String groupBrokenParagraphs(String text, String paragraphSplit, int shortLineWordThreshold) {
        String[] paragraphs = text.split(paragraphSplit);
        String[] cleanParagraphs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paragraphs)).flatMap((Function1 & Serializable & scala.Serializable)paragraph -> {
            Object object;
            if (paragraph.trim().isEmpty()) {
                object = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                String[] paraSplit = paragraph.split("\\s*\\n\\s*");
                boolean allLinesShort = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paraSplit)).forall((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)TextParser$.$anonfun$groupBrokenParagraphs$2(shortLineWordThreshold, line)));
                String trimmed = paragraph.trim();
                object = MODULE$.unicodeBulletsPattern().findFirstIn((CharSequence)trimmed).isDefined() || MODULE$.eBulletPattern().findFirstIn((CharSequence)trimmed).isDefined() ? MODULE$.groupBulletParagraph((String)paragraph) : (allLinesShort ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paraSplit)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TextParser$.$anonfun$groupBrokenParagraphs$3(x$1))))).toSeq() : (Iterable)new .colon.colon((Object)paragraph.replaceAll("\\s*\\n\\s*", " "), (List)Nil$.MODULE$));
            }
            return object;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cleanParagraphs)).mkString("\n\n");
    }

    private Seq<String> groupBulletParagraph(String paragraph) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paragraph.split("\n"))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TextParser$.$anonfun$groupBulletParagraph$2(x$3))))).toSeq();
    }

    public String autoParagraphGrouper(String text, String paragraphSplit, int maxLineCount, double threshold, int shortLineWordThreshold) {
        String[] lines = text.split("\n");
        int count = Math.min(lines.length, maxLineCount);
        IntRef emptyLineCount = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (!lines[i].trim().isEmpty()) break block0;
                ++emptyLineCount$1.elem;
            }
        });
        double ratio = (double)emptyLineCount.elem / (double)count;
        return ratio < threshold ? this.newLineGrouper(text) : this.groupBrokenParagraphs(text, paragraphSplit, shortLineWordThreshold);
    }

    private String newLineGrouper(String text) {
        String[] paragraphs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])text.split("\n"))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TextParser$.$anonfun$newLineGrouper$2(x$5)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paragraphs)).mkString("\n\n");
    }

    public static final /* synthetic */ boolean $anonfun$groupBrokenParagraphs$2(int shortLineWordThreshold$1, String line) {
        return line.trim().split("\\s+").length < shortLineWordThreshold$1;
    }

    public static final /* synthetic */ boolean $anonfun$groupBrokenParagraphs$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1.trim())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$groupBulletParagraph$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$newLineGrouper$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    private TextParser$() {
        MODULE$ = this;
        this.eBulletPattern = new StringOps(Predef$.MODULE$.augmentString("^e$")).r();
        this.unicodeBulletsPattern = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(3).append("^[").append(CleanerHelper$.MODULE$.UNICODE_BULLETS().mkString("")).append("]").toString())).r();
    }
}

