/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.reader.util.pdf;

import com.johnsnowlabs.reader.util.pdf.Character;
import com.johnsnowlabs.reader.util.pdf.PDFLayoutTextStripper;
import org.apache.pdfbox.text.TextPosition;

class CharacterFactory {
    private TextPosition previousTextPosition;
    private boolean firstCharacterOfLineFound;
    private boolean isCharacterPartOfPreviousWord;
    private boolean isFirstCharacterOfAWord;
    private boolean isCharacterAtTheBeginningOfNewLine;
    private boolean isCharacterCloseToPreviousWord;

    public CharacterFactory(boolean bl) {
        this.firstCharacterOfLineFound = bl;
    }

    public Character createCharacterFromTextPosition(TextPosition textPosition, TextPosition textPosition2, Integer n) {
        this.setPreviousTextPosition(textPosition2);
        this.isCharacterPartOfPreviousWord = this.isCharacterPartOfPreviousWord(textPosition);
        this.isFirstCharacterOfAWord = this.isFirstCharacterOfAWord(textPosition);
        this.isCharacterAtTheBeginningOfNewLine = this.isCharacterAtTheBeginningOfNewLine(textPosition);
        this.isCharacterCloseToPreviousWord = this.isCharacterCloseToPreviousWord(textPosition);
        char c = this.getCharacterFromTextPosition(textPosition, n);
        int n2 = (int)PDFLayoutTextStripper.getCorrectedX(textPosition) / PDFLayoutTextStripper.getCharacterWidth();
        return new Character(c, n2, this.isCharacterPartOfPreviousWord, this.isFirstCharacterOfAWord, this.isCharacterAtTheBeginningOfNewLine, this.isCharacterCloseToPreviousWord);
    }

    private boolean isCharacterAtTheBeginningOfNewLine(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return true;
        }
        TextPosition textPosition2 = this.getPreviousTextPosition();
        float f = textPosition2.getY();
        return Math.round(textPosition.getY()) < Math.round(f);
    }

    private boolean isFirstCharacterOfAWord(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return true;
        }
        double d = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return d > 1.0 || this.isCharacterAtTheBeginningOfNewLine(textPosition);
    }

    private boolean isCharacterCloseToPreviousWord(TextPosition textPosition) {
        if (!this.firstCharacterOfLineFound) {
            return false;
        }
        double d = this.numberOfSpacesBetweenTwoCharacters(this.previousTextPosition, textPosition);
        return d > 1.0 && d <= (double)PDFLayoutTextStripper.getCharacterWidth();
    }

    private boolean isCharacterPartOfPreviousWord(TextPosition textPosition) {
        TextPosition textPosition2 = this.getPreviousTextPosition();
        if (textPosition2.getUnicode().equals(" ")) {
            return false;
        }
        double d = this.numberOfSpacesBetweenTwoCharacters(textPosition2, textPosition);
        return d <= 1.0;
    }

    private double numberOfSpacesBetweenTwoCharacters(TextPosition textPosition, TextPosition textPosition2) {
        double d = PDFLayoutTextStripper.getCorrectedX(textPosition);
        double d2 = textPosition.getWidth();
        double d3 = d + d2;
        double d4 = Math.abs(Math.round(PDFLayoutTextStripper.getCorrectedX(textPosition2) - d3));
        return d4;
    }

    private char getCharacterFromTextPosition(TextPosition textPosition, Integer n) {
        String string = textPosition.getUnicode();
        char c = string.charAt(n);
        return c;
    }

    private TextPosition getPreviousTextPosition() {
        return this.previousTextPosition;
    }

    private void setPreviousTextPosition(TextPosition textPosition) {
        this.previousTextPosition = textPosition;
    }
}

