/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.reader.util.pdf;

import com.johnsnowlabs.reader.util.pdf.Character;
import com.johnsnowlabs.reader.util.pdf.CharacterFactory;
import com.johnsnowlabs.reader.util.pdf.TextLine;
import com.johnsnowlabs.reader.util.pdf.schema.MappingMatrix;
import com.johnsnowlabs.reader.util.pdf.schema.PageMatrix;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.text.TextPositionComparator;

public class PDFLayoutTextStripper
extends PDFTextStripper {
    public static final boolean DEBUG = false;
    public static final int DEFAULT_OUTPUT_SPACE_CHARACTER_WIDTH_IN_PT = 4;
    public static boolean FROM_PAGE_MATRIX = false;
    private double currentPageWidth;
    private TextPosition previousTextPosition = null;
    private List<TextLine> textLineList = new ArrayList<TextLine>();
    public boolean isSort = false;
    private static int outputSpaceCharacterWidth = 4;

    public String getText(PageMatrix pageMatrix, float f, float f2) throws IOException {
        this.output = new StringWriter();
        this.writePageStart();
        ArrayList<TextPosition> arrayList = new ArrayList<TextPosition>();
        for (MappingMatrix mappingMatrix : pageMatrix.mapping()) {
            TextPosition textPosition = mappingMatrix.toTextPosition(f, f2, outputSpaceCharacterWidth);
            arrayList.add(textPosition);
        }
        this.charactersByArticle.add(arrayList);
        this.writePage();
        return super.getOutput().toString();
    }

    public static int getOutputSpaceCharacterWidth() {
        return outputSpaceCharacterWidth;
    }

    public static int getCharacterWidth() {
        return 1 * outputSpaceCharacterWidth;
    }

    public static void setOutputSpaceCharacterWidth(int n) {
        outputSpaceCharacterWidth = n;
    }

    public void setIsSort(boolean bl) {
        this.isSort = bl;
    }

    public void processPage(PDPage pDPage) throws IOException {
        PDRectangle pDRectangle = pDPage.getMediaBox();
        if (pDRectangle != null) {
            this.setCurrentPageWidth(pDRectangle.getWidth());
            super.processPage(pDPage);
            this.previousTextPosition = null;
            this.textLineList = new ArrayList<TextLine>();
        }
    }

    protected void writePage() throws IOException {
        List list = super.getCharactersByArticle();
        for (int i = 0; i < list.size(); ++i) {
            List list2 = (List)list.get(i);
            if (this.isSort) {
                try {
                    this.sortTextPositionList(list2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException);
                }
            }
            this.iterateThroughTextList(list2.iterator());
        }
        this.writeToOutputStream(this.getTextLineList());
    }

    private void writeToOutputStream(List<TextLine> list) throws IOException {
        for (TextLine textLine : list) {
            char[] cArray = textLine.getLine().toCharArray();
            super.getOutput().write(cArray);
            super.getOutput().write(10);
            super.getOutput().flush();
        }
    }

    private void sortTextPositionList(List<TextPosition> list) {
        list.sort((Comparator<TextPosition>)new TextPositionComparator());
    }

    private void writeLine(List<TextPosition> list) {
        if (!list.isEmpty()) {
            TextLine textLine = this.addNewLine();
            boolean bl = false;
            for (TextPosition textPosition : list) {
                CharacterFactory characterFactory = new CharacterFactory(bl);
                Character character = characterFactory.createCharacterFromTextPosition(textPosition, this.getPreviousTextPosition(), 0);
                textLine.writeCharacterAtIndex(character);
                bl = true;
                int n = textPosition.getUnicode().length();
                for (int i = 1; i < n; ++i) {
                    Character character2 = new Character(textPosition.getUnicode().charAt(i), (int)PDFLayoutTextStripper.getCorrectedX(textPosition) / PDFLayoutTextStripper.getCharacterWidth(), true, false, false, false);
                    textLine.writeCharacterAtIndex(character2);
                }
                this.setPreviousTextPosition(textPosition);
            }
        } else {
            this.addNewLine();
        }
    }

    private void iterateThroughTextList(Iterator<TextPosition> iterator) {
        ArrayList<TextPosition> arrayList = new ArrayList<TextPosition>();
        while (iterator.hasNext()) {
            TextPosition textPosition = iterator.next();
            int n = this.getNumberOfNewLinesFromPreviousTextPosition(textPosition);
            if (n == 0) {
                arrayList.add(textPosition);
            } else {
                this.writeTextPositionList(arrayList);
                this.createNewEmptyNewLines(n);
                arrayList.add(textPosition);
            }
            this.setPreviousTextPosition(textPosition);
        }
        if (!arrayList.isEmpty()) {
            this.writeTextPositionList(arrayList);
        }
    }

    private void writeTextPositionList(List<TextPosition> list) {
        if (FROM_PAGE_MATRIX) {
            List<TextPosition> list2;
            TreeMap treeMap = new TreeMap();
            for (TextPosition object2 : list) {
                int n = (int)object2.getEndY() / (4 * outputSpaceCharacterWidth);
                list2 = treeMap.containsKey(n) ? (List)treeMap.get(n) : new ArrayList();
                list2.add(object2);
                treeMap.put(n, list2);
            }
            TreeSet treeSet = new TreeSet(treeMap.keySet());
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Integer n = (Integer)iterator.next();
                list2 = (List)treeMap.get(n);
                TreeMap<Integer, Object> treeMap2 = new TreeMap<Integer, Object>();
                for (Object object2 : list2) {
                    int n2 = (int)object2.getEndX();
                    treeMap2.put(n2, object2);
                }
                TreeSet treeSet2 = new TreeSet(treeMap2.keySet());
                object2 = new ArrayList();
                Iterator n2 = treeSet2.iterator();
                while (n2.hasNext()) {
                    Integer n3 = (Integer)n2.next();
                    object2.add(treeMap2.get(n3));
                }
                this.writeLine((List<TextPosition>)object2);
            }
        } else {
            this.writeLine(list);
        }
        list.clear();
    }

    private void createNewEmptyNewLines(int n) {
        for (int i = 0; i < n - 1; ++i) {
            this.addNewLine();
        }
    }

    private int getNumberOfNewLinesFromPreviousTextPosition(TextPosition textPosition) {
        float f;
        TextPosition textPosition2 = this.getPreviousTextPosition();
        if (textPosition2 == null) {
            return 1;
        }
        float f2 = Math.round(textPosition.getY());
        if (f2 > (f = (float)Math.round(textPosition2.getY())) && (double)(f2 - f) > 5.5) {
            double d = textPosition.getHeight();
            int n = (int)(Math.floor(f2 - f) / d);
            n = Math.max(1, n - 1);
            return n;
        }
        return 0;
    }

    private TextLine addNewLine() {
        TextLine textLine = new TextLine(this.getCurrentPageWidth());
        this.textLineList.add(textLine);
        return textLine;
    }

    private TextPosition getPreviousTextPosition() {
        return this.previousTextPosition;
    }

    private void setPreviousTextPosition(TextPosition textPosition) {
        this.previousTextPosition = textPosition;
    }

    private int getCurrentPageWidth() {
        return (int)Math.round(this.currentPageWidth);
    }

    public void setCurrentPageWidth(double d) {
        this.currentPageWidth = d;
    }

    private List<TextLine> getTextLineList() {
        return this.textLineList;
    }

    public static double getCorrectedX(TextPosition textPosition) {
        if (FROM_PAGE_MATRIX) {
            return textPosition.getEndX() - textPosition.getIndividualWidths()[0];
        }
        return textPosition.getX();
    }
}

