/*
 * Decompiled with CFR 0.152.
 */
package com.johnsnowlabs.reader.util.pdf;

import com.johnsnowlabs.reader.util.pdf.Character;
import com.johnsnowlabs.reader.util.pdf.PDFLayoutTextStripper;

class TextLine {
    private static final char SPACE_CHARACTER = ' ';
    private int lineLength;
    private String line = "";
    private int lastIndex;

    public TextLine(int n) {
        this.lineLength = n / PDFLayoutTextStripper.getCharacterWidth();
        this.completeLineWithSpaces();
    }

    public void writeCharacterAtIndex(Character character) {
        character.setIndex(this.computeIndexForCharacter(character));
        int n = character.getIndex();
        char c = character.getCharacterValue();
        if (this.indexIsInBounds(n) && this.line.charAt(n) == ' ') {
            this.line = this.line.substring(0, n) + c + this.line.substring(n + 1, this.getLineLength());
        }
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public String getLine() {
        return this.line;
    }

    private int computeIndexForCharacter(Character character) {
        int n = character.getIndex();
        boolean bl = character.isCharacterPartOfPreviousWord();
        boolean bl2 = character.isCharacterAtTheBeginningOfNewLine();
        boolean bl3 = character.isCharacterCloseToPreviousWord();
        if (!this.indexIsInBounds(n)) {
            return -1;
        }
        if (bl && !bl2) {
            n = this.findMinimumIndexWithSpaceCharacterFromIndex(n);
        } else if (bl3) {
            n = this.line.charAt(n) != ' ' ? ++n : this.findMinimumIndexWithSpaceCharacterFromIndex(n) + 1;
        }
        n = this.getNextValidIndex(n, bl);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSpaceCharacterAtIndex(int n) {
        boolean bl = false;
        try {
            this.line.charAt(n);
            if (this.line.charAt(n) > '\u0000') {
                boolean bl2 = bl = this.line.charAt(n) != ' ';
                return bl2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            bl = false;
            return bl;
        }
        finally {
            return bl;
        }
    }

    private boolean isNewIndexGreaterThanLastIndex(int n) {
        int n2 = this.getLastIndex();
        return n > n2;
    }

    private int getNextValidIndex(int n, boolean bl) {
        int n2 = n;
        int n3 = this.getLastIndex();
        if (!this.isNewIndexGreaterThanLastIndex(n)) {
            n2 = n3 + 1;
        }
        if (!bl && this.isSpaceCharacterAtIndex(n - 1)) {
            ++n2;
        }
        this.setLastIndex(n2);
        return n2;
    }

    private int findMinimumIndexWithSpaceCharacterFromIndex(int n) {
        int n2;
        for (n2 = n; n2 >= 0 && this.line.charAt(n2) == ' '; --n2) {
        }
        return n2 + 1;
    }

    private boolean indexIsInBounds(int n) {
        return n >= 0 && n < this.lineLength;
    }

    private void completeLineWithSpaces() {
        for (int i = 0; i < this.getLineLength(); ++i) {
            this.line = this.line + ' ';
        }
    }

    private int getLastIndex() {
        return this.lastIndex;
    }

    private void setLastIndex(int n) {
        this.lastIndex = n;
    }
}

