/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp.provider;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.hooks.ConnectionHook;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoneCPConnectionProvider
implements ConnectionProvider {
    protected static final String CONFIG_CONNECTION_DRIVER_CLASS = "hibernate.connection.driver_class";
    protected static final String CONFIG_CONNECTION_PASSWORD = "hibernate.connection.password";
    protected static final String CONFIG_CONNECTION_USERNAME = "hibernate.connection.username";
    protected static final String CONFIG_CONNECTION_URL = "hibernate.connection.url";
    protected static final String CONFIG_CONNECTION_DRIVER_CLASS_ALTERNATE = "javax.persistence.jdbc.driver";
    protected static final String CONFIG_CONNECTION_PASSWORD_ALTERNATE = "javax.persistence.jdbc.password";
    protected static final String CONFIG_CONNECTION_USERNAME_ALTERNATE = "javax.persistence.jdbc.user";
    protected static final String CONFIG_CONNECTION_URL_ALTERNATE = "javax.persistence.jdbc.url";
    private BoneCP pool;
    private Integer isolation;
    private boolean autocommit;
    private ClassLoader classLoader;
    private BoneCPConfig config;
    private static Logger logger = LoggerFactory.getLogger(BoneCPConnectionProvider.class);

    public void close() throws HibernateException {
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        try {
            this.config = new BoneCPConfig(props);
            String url = props.getProperty(CONFIG_CONNECTION_URL);
            String username = props.getProperty(CONFIG_CONNECTION_USERNAME);
            String password = props.getProperty(CONFIG_CONNECTION_PASSWORD);
            String driver = props.getProperty(CONFIG_CONNECTION_DRIVER_CLASS);
            if (url == null) {
                url = props.getProperty(CONFIG_CONNECTION_URL_ALTERNATE);
            }
            if (username == null) {
                username = props.getProperty(CONFIG_CONNECTION_USERNAME_ALTERNATE);
            }
            if (password == null) {
                password = props.getProperty(CONFIG_CONNECTION_PASSWORD_ALTERNATE);
            }
            if (driver == null) {
                driver = props.getProperty(CONFIG_CONNECTION_DRIVER_CLASS_ALTERNATE);
            }
            if (url != null) {
                this.config.setJdbcUrl(url);
            }
            if (username != null) {
                this.config.setUsername(username);
            }
            if (password != null) {
                this.config.setPassword(password);
            }
            this.isolation = PropertiesHelper.getInteger((String)"hibernate.connection.isolation", (Properties)props);
            this.autocommit = PropertiesHelper.getBoolean((String)"hibernate.connection.autocommit", (Properties)props);
            logger.debug(this.config.toString());
            if (driver != null && !driver.trim().equals("")) {
                this.loadClass(driver);
            }
            if (this.config.getConnectionHookClassName() != null) {
                Object hookClass = this.loadClass(this.config.getConnectionHookClassName()).newInstance();
                this.config.setConnectionHook((ConnectionHook)hookClass);
            }
            this.pool = this.createPool(this.config);
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    protected Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(clazz);
        }
        return Class.forName(clazz, true, this.classLoader);
    }

    protected BoneCP createPool(BoneCPConfig config) {
        try {
            return new BoneCP(config);
        }
        catch (SQLException e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        Connection connection = this.pool.getConnection();
        try {
            if (this.isolation != null && connection.getTransactionIsolation() != this.isolation.intValue()) {
                connection.setTransactionIsolation(this.isolation);
            }
            if (connection.getAutoCommit() != this.autocommit) {
                connection.setAutoCommit(this.autocommit);
            }
            return connection;
        }
        catch (SQLException e) {
            try {
                connection.close();
            }
            catch (Exception e2) {
                logger.warn("Setting connection properties failed and closing this connection failed again", (Throwable)e);
            }
            throw e;
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    protected BoneCPConfig getConfig() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

