/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.google.common.base.FinalizableReferenceQueue;
import com.google.common.base.FinalizableWeakReference;
import com.jolbox.bonecp.AbstractConnectionStrategy;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionStrategy;
import java.lang.ref.Reference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedConnectionStrategy
extends AbstractConnectionStrategy {
    static Logger logger = LoggerFactory.getLogger(CachedConnectionStrategy.class);
    private volatile AtomicBoolean warnApp = new AtomicBoolean();
    final Map<ConnectionHandle, Reference<Thread>> finalizableRefs = new ConcurrentHashMap<ConnectionHandle, Reference<Thread>>();
    private FinalizableReferenceQueue finalizableRefQueue = new FinalizableReferenceQueue();
    private ConnectionStrategy fallbackStrategy;
    private ThreadLocal<ConnectionHandle> tlConnections = new ThreadLocal<ConnectionHandle>(){

        @Override
        protected ConnectionHandle initialValue() {
            ConnectionHandle result;
            try {
                result = CachedConnectionStrategy.this.pollFallbackConnection();
            }
            catch (SQLException e) {
                result = null;
            }
            return result;
        }

        @Override
        public ConnectionHandle get() {
            ConnectionHandle result = (ConnectionHandle)super.get();
            if (result != null && !result.inUseInThreadLocalContext.compareAndSet(false, true)) {
                try {
                    result = CachedConnectionStrategy.this.pollFallbackConnection();
                }
                catch (SQLException e) {
                    result = null;
                }
            }
            return result;
        }
    };

    private CachedConnectionStrategy() {
    }

    public static ConnectionStrategy getInstance(BoneCP pool, ConnectionStrategy fallbackStrategy) {
        CachedConnectionStrategy cs = SingletonHolder.INSTANCE;
        cs.pool = pool;
        cs.fallbackStrategy = fallbackStrategy;
        return cs;
    }

    ConnectionHandle pollFallbackConnection() throws SQLException {
        ConnectionHandle result = (ConnectionHandle)this.fallbackStrategy.pollConnection();
        if (result != null) {
            this.threadWatch(result);
        }
        return result;
    }

    private synchronized void stealExistingAllocations() {
        for (ConnectionHandle handle : this.finalizableRefs.keySet()) {
            if (!handle.inUseInThreadLocalContext.compareAndSet(false, true)) continue;
            try {
                this.pool.releaseConnection(handle);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.warnApp.compareAndSet(false, true)) {
            logger.warn("Cached strategy chosen, but more threads are requesting a connection than are configured. Switching permanently to default strategy.");
        }
        this.finalizableRefs.clear();
    }

    private void threadWatch(final ConnectionHandle handle) {
        this.finalizableRefs.put(handle, (Reference<Thread>)new FinalizableWeakReference<Thread>(Thread.currentThread(), this.finalizableRefQueue){

            public void finalizeReferent() {
                try {
                    if (!CachedConnectionStrategy.this.pool.poolShuttingDown) {
                        logger.debug("Monitored thread is dead, closing off allocated connection.");
                    }
                    handle.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                CachedConnectionStrategy.this.finalizableRefs.remove(handle);
            }
        });
    }

    @Override
    protected Connection getConnectionInternal() throws SQLException {
        ConnectionHandle result = this.tlConnections.get();
        if (result == null) {
            this.pool.cachedPoolStrategy = false;
            this.pool.connectionStrategy = this.fallbackStrategy;
            this.stealExistingAllocations();
            result = (ConnectionHandle)this.pool.connectionStrategy.getConnection();
        }
        return result;
    }

    @Override
    public ConnectionHandle pollConnection() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void terminateAllConnections() {
        for (ConnectionHandle conn : this.finalizableRefs.keySet()) {
            this.pool.destroyConnection(conn);
        }
        this.finalizableRefs.clear();
        this.fallbackStrategy.terminateAllConnections();
    }

    private static class SingletonHolder {
        public static final CachedConnectionStrategy INSTANCE = new CachedConnectionStrategy();

        private SingletonHolder() {
        }
    }
}

