/*
 * Decompiled with CFR 0.152.
 */
package com.jolbox.bonecp;

import com.jolbox.bonecp.AbstractConnectionStrategy;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.ConnectionHandle;
import com.jolbox.bonecp.ConnectionPartition;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;

public class DefaultConnectionStrategy
extends AbstractConnectionStrategy {
    public DefaultConnectionStrategy(BoneCP pool) {
        this.pool = pool;
    }

    @Override
    public ConnectionHandle pollConnection() {
        ConnectionHandle result = null;
        int partition = (int)(Thread.currentThread().getId() % (long)this.pool.partitionCount);
        ConnectionPartition connectionPartition = this.pool.partitions[partition];
        result = (ConnectionHandle)connectionPartition.getFreeConnections().poll();
        if (result == null) {
            for (int i = 0; i < this.pool.partitionCount; ++i) {
                if (i == partition) continue;
                result = (ConnectionHandle)this.pool.partitions[i].getFreeConnections().poll();
                connectionPartition = this.pool.partitions[i];
                if (result != null) break;
            }
        }
        if (!connectionPartition.isUnableToCreateMoreTransactions()) {
            this.pool.maybeSignalForMoreConnections(connectionPartition);
        }
        return result;
    }

    @Override
    protected Connection getConnectionInternal() throws SQLException {
        ConnectionHandle result = this.pollConnection();
        int partition = (int)(Thread.currentThread().getId() % (long)this.pool.partitionCount);
        ConnectionPartition connectionPartition = this.pool.partitions[partition];
        if (result == null) {
            try {
                result = (ConnectionHandle)connectionPartition.getFreeConnections().poll(this.pool.connectionTimeoutInMs, TimeUnit.MILLISECONDS);
                if (result == null) {
                    if (this.pool.nullOnConnectionTimeout) {
                        return null;
                    }
                    throw new SQLException("Timed out waiting for a free available connection.", "08001");
                }
            }
            catch (InterruptedException e) {
                if (this.pool.nullOnConnectionTimeout) {
                    return null;
                }
                throw new SQLException(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateAllConnections() {
        this.terminationLock.lock();
        try {
            for (int i = 0; i < this.pool.partitionCount; ++i) {
                ConnectionHandle conn;
                this.pool.partitions[i].setUnableToCreateMoreTransactions(false);
                while ((conn = (ConnectionHandle)this.pool.partitions[i].getFreeConnections().poll()) != null) {
                    this.pool.destroyConnection(conn);
                }
            }
        }
        finally {
            this.terminationLock.unlock();
        }
    }
}

