/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.java.dev.hickory.testing.MemClassLoader;
import net.java.dev.hickory.testing.MemFileManager;
import net.java.dev.hickory.testing.MemSourceFileObject;

public class MethodVerifier {
    Class<?> target;
    private DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector();

    public MethodVerifier(Class<?> target) {
        this.target = target;
    }

    public boolean hasMethod(String signature, String classTypeVarNames, String ... imports) {
        boolean methodIsAbstract;
        StringBuilder source = new StringBuilder();
        for (String imported : imports) {
            source.append("import ").append(imported).append(";\n");
        }
        boolean bl = methodIsAbstract = signature.startsWith("abstract ") || signature.contains(" abstract ");
        if (methodIsAbstract) {
            source.append("abstract ");
        }
        source.append("class __Wrapper__");
        if (classTypeVarNames != null) {
            source.append("<").append(classTypeVarNames).append(">");
        }
        source.append(" {\n");
        source.append("    ").append(signature);
        if (methodIsAbstract) {
            source.append(";\n");
        } else {
            source.append(" {\n");
            source.append("        throw new UnsupportedOperationException();\n    }\n");
        }
        source.append("}\n");
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        MemFileManager rfm = this.target.getClassLoader() instanceof MemClassLoader ? ((MemClassLoader)this.target.getClassLoader()).getFileManager() : new MemFileManager(compiler.getStandardFileManager(this.diagnostics, null, null));
        MemSourceFileObject jfo = new MemSourceFileObject("__Wrapper__");
        jfo.addLine(source.toString());
        ArrayList<MemSourceFileObject> jfos = new ArrayList<MemSourceFileObject>();
        jfos.add(jfo);
        List<String> options = Collections.emptyList();
        boolean ok = compiler.getTask(null, rfm, this.diagnostics, options, null, jfos).call();
        if (!ok) {
            throw new IllegalArgumentException(this.diagnostics.getDiagnostics().toString());
        }
        try {
            Class<?> example = rfm.getClassLoader(StandardLocation.CLASS_OUTPUT).loadClass("__Wrapper__");
            return this.hasMethod(example);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean hasMethod(Class<?> example) {
        if (example.getDeclaredMethods().length != 1) {
            throw new IllegalArgumentException("example must declare exactly one method");
        }
        Method sample = example.getDeclaredMethods()[0];
        for (Method maybe : this.target.getDeclaredMethods()) {
            if (!this.match(maybe, sample)) continue;
            return true;
        }
        return false;
    }

    private boolean match(Method poss, Method sample) {
        if (poss.getModifiers() != sample.getModifiers()) {
            return false;
        }
        if (!poss.getName().equals(sample.getName())) {
            return false;
        }
        if (!this.matchesTypeParameters(poss.getTypeParameters(), sample.getTypeParameters())) {
            return false;
        }
        if (!this.orderedMatch(poss.getGenericParameterTypes(), sample.getGenericParameterTypes())) {
            return false;
        }
        if (!this.sameTypes(poss.getGenericReturnType(), sample.getGenericReturnType())) {
            return false;
        }
        return this.unorderedMatch(poss.getGenericExceptionTypes(), sample.getGenericExceptionTypes());
    }

    private boolean matchesTypeParameters(TypeVariable<Method>[] vars1, TypeVariable<Method>[] vars2) {
        if (vars1.length != vars2.length) {
            return false;
        }
        for (int i = 0; i < vars1.length; ++i) {
            if (this.sameTypes(vars1[i], vars2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean orderedMatch(Type[] type, Type[] type0) {
        if (type.length != type0.length) {
            return false;
        }
        for (int i = 0; i < type.length; ++i) {
            if (this.sameTypes(type[i], type0[i])) continue;
            return false;
        }
        return true;
    }

    private boolean unorderedMatch(Type[] ta1, Type[] ta2) {
        if (ta1.length != ta2.length) {
            return false;
        }
        boolean[] matched = new boolean[ta1.length];
        for (int i = 0; i < ta1.length; ++i) {
            block4: {
                for (int j = 0; j < ta1.length; ++j) {
                    if (matched[j] || !this.sameTypes(ta1[i], ta2[j])) {
                        continue;
                    }
                    break block4;
                }
                return false;
            }
            matched[j] = true;
        }
        return true;
    }

    private boolean sameTypes(Type type1, Type type2) {
        if (type1 instanceof Class) {
            return type2 instanceof Class ? ((Class)type1).equals((Class)type2) : false;
        }
        if (type1 instanceof GenericArrayType) {
            return type2 instanceof GenericArrayType ? this.sameTypes((GenericArrayType)type1, (GenericArrayType)type2) : false;
        }
        if (type1 instanceof ParameterizedType) {
            return type2 instanceof ParameterizedType ? this.sameTypes((ParameterizedType)type1, (ParameterizedType)type2) : false;
        }
        if (type1 instanceof TypeVariable) {
            return type2 instanceof TypeVariable ? this.sameTypes((TypeVariable)type1, (TypeVariable)type2) : false;
        }
        if (type1 instanceof WildcardType) {
            return type2 instanceof WildcardType ? this.sameTypes((WildcardType)type1, (WildcardType)type2) : false;
        }
        return false;
    }

    private boolean sameTypes(GenericArrayType t1, GenericArrayType t2) {
        return this.sameTypes(t1.getGenericComponentType(), t2.getGenericComponentType());
    }

    private boolean sameTypes(ParameterizedType t1, ParameterizedType t2) {
        return this.sameTypes(t1.getRawType(), t2.getRawType()) && this.orderedMatch(t1.getActualTypeArguments(), t2.getActualTypeArguments());
    }

    private boolean sameTypes(TypeVariable v1, TypeVariable v2) {
        return v1.getName().equals(v2.getName()) && this.unorderedMatch(v1.getBounds(), v2.getBounds());
    }

    private boolean sameTypes(WildcardType w1, WildcardType w2) {
        return this.unorderedMatch(w1.getLowerBounds(), w2.getLowerBounds()) && this.unorderedMatch(w1.getUpperBounds(), w2.getUpperBounds());
    }
}

