/*
 * Decompiled with CFR 0.152.
 */
package rpcfy.compiler;

import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import rpcfy.annotations.RPCfy;
import rpcfy.compiler.builder.BindingManager;

public class RpcfyProcessor
extends AbstractProcessor {
    private BindingManager bindingManager;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.messager = env.getMessager();
        this.bindingManager = new BindingManager(env.getElementUtils(), env.getFiler(), this.messager, env.getTypeUtils());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> types = new LinkedHashSet<String>();
        for (Class<? extends Annotation> annotation : this.getSupportedAnnotations()) {
            types.add(annotation.getCanonicalName());
        }
        return types;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private Set<Class<? extends Annotation>> getSupportedAnnotations() {
        LinkedHashSet<Class<? extends Annotation>> annotations = new LinkedHashSet<Class<? extends Annotation>>();
        annotations.add(RPCfy.class);
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        for (Element element : env.getElementsAnnotatedWith(RPCfy.class)) {
            if (element.getKind() == ElementKind.INTERFACE) {
                this.bindingManager.generateProxy(element);
                this.bindingManager.generateStub(element);
                continue;
            }
            this.messager.printMessage(Diagnostic.Kind.WARNING, "@RPCfy is expected only for interface. Ignoring " + element.getSimpleName());
        }
        return false;
    }
}

