/*
 * Decompiled with CFR 0.152.
 */
package rpcfy.compiler.builder;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import rpcfy.annotations.RPCfy;
import rpcfy.compiler.builder.ClassBuilder;
import rpcfy.compiler.builder.FieldBuilder;
import rpcfy.compiler.builder.MethodBuilder;

public final class BindingManager {
    private Elements elementUtils;
    private Messager messager;
    private Types typeUtils;
    private Filer filer;

    public BindingManager(Elements elementUtils, Filer filer, Messager messager, Types typeUtils) {
        this.elementUtils = elementUtils;
        this.filer = filer;
        this.messager = messager;
        this.typeUtils = typeUtils;
    }

    public void generateProxy(Element element) {
        try {
            this.getClassBuilder(element).buildProxyClass().build().writeTo(this.filer);
        }
        catch (Exception ex) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Error while generating Proxy " + ex.getMessage());
        }
    }

    public void generateStub(Element element) {
        try {
            this.getClassBuilder(element).buildStubClass().build().writeTo(this.filer);
        }
        catch (Exception ex) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Error while generating Stub " + ex.getMessage());
        }
    }

    private ClassBuilder getClassBuilder(Element element) {
        ClassBuilder classBuilder = new ClassBuilder(this.messager, element);
        classBuilder.setBindingManager(this);
        return classBuilder;
    }

    FieldBuilder getFieldBuilder(Element element) {
        FieldBuilder fieldBuilder = new FieldBuilder(this.messager, element);
        fieldBuilder.setBindingManager(this);
        return fieldBuilder;
    }

    MethodBuilder getMethodBuilder(Element element) {
        MethodBuilder methodBuilder = new MethodBuilder(this.messager, element);
        methodBuilder.setBindingManager(this);
        return methodBuilder;
    }

    boolean isParameterOfTypeTPCfy(TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement;
            String typeName = typeMirror.toString();
            int templateStart = typeName.indexOf(60);
            if (templateStart != -1) {
                typeName = typeName.substring(0, templateStart).trim();
            }
            if ((typeElement = this.elementUtils.getTypeElement(typeName)) != null && typeElement.getKind() == ElementKind.INTERFACE && typeElement.getAnnotation(RPCfy.class) != null) {
                return true;
            }
        }
        return false;
    }
}

