/*
 * Decompiled with CFR 0.152.
 */
package rpcfy.compiler.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import rpcfy.JSONify;
import rpcfy.JsonRPCMessageHandler;
import rpcfy.RPCProxy;
import rpcfy.RPCStub;
import rpcfy.compiler.builder.RpcfyBuilder;
import rpcfy.json.GsonJsonify;

class ClassBuilder
extends RpcfyBuilder {
    static final String PROXY_SUFFIX = "_JsonRpcProxy";
    static final String STUB_SUFFIX = "_JsonRpcStub";

    protected ClassBuilder(Messager messager, Element element) {
        super(messager, element);
    }

    public JavaFile.Builder buildProxyClass() {
        ClassName proxyClassName = this.getProxyClassName();
        TypeSpec.Builder proxyClassBuilder = TypeSpec.classBuilder((String)proxyClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get(RPCProxy.class)).addSuperinterface(TypeName.get((TypeMirror)this.getRemoterInterfaceElement().asType()));
        for (TypeParameterElement typeParameterElement : ((TypeElement)this.getRemoterInterfaceElement()).getTypeParameters()) {
            proxyClassBuilder.addTypeVariable(TypeVariableName.get((String)typeParameterElement.toString()));
        }
        proxyClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Initialize this {@link " + this.getProxyClassName().simpleName() + "} with the given {@link JsonRPCMessageHandler}\n\n", new Object[0]).addJavadoc("@param rpcHandler A {@link JsonRPCMessageHandler} to send the generated JSONRPC messages\n", new Object[0]).addParameter(JsonRPCMessageHandler.class, "rpcHandler", new Modifier[0]).addStatement("this(rpcHandler, new $T())", new Object[]{GsonJsonify.class}).build());
        proxyClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Initialize this {@link " + this.getProxyClassName().simpleName() + "} with the given {@link JsonRPCMessageHandler}\n\n", new Object[0]).addJavadoc("@param rpcHandler A {@link JsonRPCMessageHandler} to send the generated JSONRPC messages\n", new Object[0]).addJavadoc("@param jsonify A custom implementation of  {@link JSONify} \n", new Object[0]).addParameter(JsonRPCMessageHandler.class, "rpcHandler", new Modifier[0]).addParameter(JSONify.class, "jsonify", new Modifier[0]).addStatement("this(rpcHandler, jsonify, null)", new Object[0]).build());
        proxyClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Initialize this {@link " + this.getProxyClassName().simpleName() + "} with the given {@link JsonRPCMessageHandler}\n\n", new Object[0]).addJavadoc("@param rpcHandler A {@link JsonRPCMessageHandler} to send the generated JSONRPC messages\n", new Object[0]).addJavadoc("@param jsonify A custom implementation of  {@link JSONify} \n", new Object[0]).addJavadoc("@param remoteID A unique id to represent this instance \n", new Object[0]).addParameter(JsonRPCMessageHandler.class, "rpcHandler", new Modifier[0]).addParameter(JSONify.class, "jsonify", new Modifier[0]).addParameter(Integer.class, "remoteID", new Modifier[0]).addStatement("this(rpcHandler, jsonify, remoteID, null)", new Object[0]).build());
        proxyClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Initialize this {@link " + this.getProxyClassName().simpleName() + "} with the given {@link JsonRPCMessageHandler}\n\n", new Object[0]).addJavadoc("@param rpcHandler A {@link JsonRPCMessageHandler} to send the generated JSONRPC messages\n", new Object[0]).addJavadoc("@param jsonify A custom implementation of  {@link JSONify} \n", new Object[0]).addJavadoc("@param remoteID A unique id to represent this instance \n", new Object[0]).addParameter(JsonRPCMessageHandler.class, "rpcHandler", new Modifier[0]).addParameter(JSONify.class, "jsonify", new Modifier[0]).addParameter(Integer.class, "remoteID", new Modifier[0]).addParameter(Integer.class, "remoteHandlerID", new Modifier[0]).addStatement("this.rpcHandler = rpcHandler", new Object[0]).addStatement("this.jsonify = jsonify", new Object[0]).addStatement("this.remoteID = remoteID", new Object[0]).addStatement("this.remoteHandlerID = remoteHandlerID", new Object[0]).build());
        this.getBindingManager().getFieldBuilder(this.getRemoterInterfaceElement()).addProxyFields(proxyClassBuilder);
        this.getBindingManager().getMethodBuilder(this.getRemoterInterfaceElement()).addProxyMethods(proxyClassBuilder);
        proxyClassBuilder.addJavadoc("An RPC Proxy for {@link " + this.getRemoterInterfaceElement() + "} interface\n", new Object[0]);
        proxyClassBuilder.addJavadoc("<p>\n", new Object[0]);
        proxyClassBuilder.addJavadoc("Autogenerated by <a href=\"http://bit.ly/RPCfy\">RPCfy</a>\n", new Object[0]);
        proxyClassBuilder.addJavadoc("@see " + this.getStubClassName().simpleName() + "\n", new Object[0]);
        return JavaFile.builder((String)proxyClassName.packageName(), (TypeSpec)proxyClassBuilder.build());
    }

    public JavaFile.Builder buildStubClass() {
        ClassName stubClassName = this.getStubClassName();
        TypeSpec.Builder stubClassBuilder = TypeSpec.classBuilder((String)stubClassName.simpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ClassName.get(RPCStub.class));
        stubClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Initialize this {@link " + this.getStubClassName().simpleName() + "} with the given {@link " + this.getRemoterInterfaceElement() + "}.\n<p/>\n", new Object[0]).addJavadoc("This will also registers this stub instance with the given {@link JsonRPCMessageHandler}. \n", new Object[0]).addJavadoc("@param rpcHandler A {@link JsonRPCMessageHandler} to send the generated JSONRPC messages and process the incoming messages\n", new Object[0]).addJavadoc("@param service An implementation of {@link " + this.getRemoterInterfaceClassName() + "}\n", new Object[0]).addParameter(JsonRPCMessageHandler.class, "rpcHandler", new Modifier[0]).addParameter(TypeName.get((TypeMirror)this.getRemoterInterfaceElement().asType()), "service", new Modifier[0]).addStatement("this(rpcHandler, service, new $T())", new Object[]{GsonJsonify.class}).build());
        stubClassBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc("Initialize this {@link " + this.getStubClassName().simpleName() + "} with the given {@link " + this.getRemoterInterfaceElement() + "}.\n<p/>\n", new Object[0]).addJavadoc("This will also registers this stub instance with the given {@link JsonRPCMessageHandler}. \n", new Object[0]).addJavadoc("@param rpcHandler A {@link JsonRPCMessageHandler} to send the generated JSONRPC messages and process the incoming messages\n", new Object[0]).addJavadoc("@param service An implementation of {@link " + this.getRemoterInterfaceClassName() + "}\n", new Object[0]).addJavadoc("@param jsonify A custom implementation of  {@link JSONify} \n", new Object[0]).addParameter(JsonRPCMessageHandler.class, "rpcHandler", new Modifier[0]).addParameter(TypeName.get((TypeMirror)this.getRemoterInterfaceElement().asType()), "service", new Modifier[0]).addParameter(JSONify.class, "jsonify", new Modifier[0]).addStatement("this.rpcHandler = rpcHandler", new Object[0]).addStatement("this.jsonify = jsonify", new Object[0]).addStatement("this.service = service", new Object[0]).addStatement("this.remoteID = service.hashCode()", new Object[0]).addStatement("rpcHandler.registerStub(this)", new Object[0]).build());
        this.getBindingManager().getFieldBuilder(this.getRemoterInterfaceElement()).addStubFields(stubClassBuilder);
        this.getBindingManager().getMethodBuilder(this.getRemoterInterfaceElement()).addStubMethods(stubClassBuilder);
        stubClassBuilder.addJavadoc("An RPC Stub for {@link " + this.getRemoterInterfaceElement() + "} interface\n", new Object[0]);
        stubClassBuilder.addJavadoc("<p>\n", new Object[0]);
        stubClassBuilder.addJavadoc("Autogenerated by <a href=\"http://bit.ly/RPCfy\">RPCfy</a>\n", new Object[0]);
        stubClassBuilder.addJavadoc("@see " + this.getProxyClassName().simpleName() + "\n", new Object[0]);
        return JavaFile.builder((String)stubClassName.packageName(), (TypeSpec)stubClassBuilder.build());
    }

    private ClassName getStubClassName() {
        return ClassName.get((String)this.getRemoterInterfacePackageName(), (String)(this.getRemoterInterfaceClassName() + STUB_SUFFIX), (String[])new String[0]);
    }

    private ClassName getProxyClassName() {
        return ClassName.get((String)this.getRemoterInterfacePackageName(), (String)(this.getRemoterInterfaceClassName() + PROXY_SUFFIX), (String[])new String[0]);
    }
}

