/*
 * Decompiled with CFR 0.152.
 */
package rpcfy.compiler.builder;

import com.google.gson.reflect.TypeToken;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import rpcfy.JSONify;
import rpcfy.RPCException;
import rpcfy.RPCMethodDelegate;
import rpcfy.RPCNotSupportedException;
import rpcfy.RPCProxy;
import rpcfy.RPCStub;
import rpcfy.annotations.RPCfyNotSupported;
import rpcfy.compiler.builder.RpcfyBuilder;

class MethodBuilder
extends RpcfyBuilder {
    protected MethodBuilder(Messager messager, Element element) {
        super(messager, element);
    }

    public void addProxyMethods(TypeSpec.Builder classBuilder) {
        this.processRemoterElements(classBuilder, new RpcfyBuilder.ElementVisitor(){

            @Override
            public void visitElement(TypeSpec.Builder classBuilder, Element member, int methodIndex, MethodSpec.Builder methodBuilder) {
                MethodBuilder.this.addProxyMethods(classBuilder, member, methodIndex);
            }
        }, null);
        this.addProxyExtras(classBuilder);
    }

    private void addProxyMethods(TypeSpec.Builder classBuilder, Element member, int methodIndex) {
        boolean bl;
        ExecutableElement executableElement = (ExecutableElement)member;
        String methodName = executableElement.getSimpleName().toString();
        boolean isOneWay = executableElement.getReturnType().getKind() == TypeKind.VOID;
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)executableElement.getReturnType()));
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            methodBuilder.addException((TypeName)ClassName.bestGuess((String)typeMirror.toString()));
        }
        int paramIndex = 0;
        for (VariableElement variableElement : executableElement.getParameters()) {
            methodBuilder.addParameter(TypeName.get((TypeMirror)variableElement.asType()), variableElement.getSimpleName().toString() + "_" + paramIndex, new Modifier[0]);
            ++paramIndex;
        }
        boolean bl2 = bl = member.getAnnotation(RPCfyNotSupported.class) != null;
        if (bl) {
            methodBuilder.addStatement("throw new $T(\"Method '" + methodName + "' does not support RPC call\")", new Object[]{RPCNotSupportedException.class});
            classBuilder.addMethod(methodBuilder.build());
            return;
        }
        methodBuilder.addStatement(this.getRemoterInterfaceClassName() + " methodDelegate = (" + this.getRemoterInterfaceClassName() + ")rpcHandler.getMethodDelegate(new $T(" + this.getRemoterInterfaceClassName() + ".class, METHOD_" + methodName + "_" + methodIndex + ", null))", new Object[]{RPCMethodDelegate.class});
        methodBuilder.beginControlFlow("if (methodDelegate != null)", new Object[0]);
        methodBuilder.beginControlFlow("try", new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        if (!isOneWay) {
            stringBuilder.append("return ");
        }
        stringBuilder.append("methodDelegate.");
        stringBuilder.append(methodName);
        stringBuilder.append("(");
        paramIndex = 0;
        int totalParams = executableElement.getParameters().size();
        for (VariableElement variableElement : executableElement.getParameters()) {
            stringBuilder.append(variableElement.getSimpleName().toString() + "_" + paramIndex);
            if (++paramIndex >= totalParams) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        methodBuilder.addStatement(stringBuilder.toString(), new Object[0]);
        if (isOneWay) {
            methodBuilder.addStatement("return", new Object[0]);
        }
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("catch($T delegateException)", new Object[]{RPCMethodDelegate.DelegateIgnoreException.class});
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$T jsonRPCObject = jsonify.newJson()", new Object[]{JSONify.JObject.class});
        methodBuilder.addStatement("String interfaceName = \"" + this.getRemteInterfaceFQName() + "\"", new Object[0]);
        methodBuilder.addStatement("int methodID = METHOD_" + methodName + "_" + methodIndex, new Object[0]);
        methodBuilder.addStatement("int rpcCallId = idGenerator.incrementAndGet()", new Object[0]);
        methodBuilder.addStatement("int proxyInstanceId = super.hashCode()", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"jsonrpc\", \"2.0\")", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"method\", \"" + methodName + "\")", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"interface\", interfaceName )", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"method_id\", methodID)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"ins_id\", proxyInstanceId)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"handler_id\", rpcHandler.hashCode())", new Object[0]);
        methodBuilder.beginControlFlow("if (remoteHandlerID != null)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"r_handler_id\", remoteHandlerID)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("if (remoteID != null)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"remote_id\", remoteID)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("JSONify.JObject paramsObject = jsonify.newJson()", new Object[0]);
        paramIndex = 0;
        for (VariableElement variableElement : executableElement.getParameters()) {
            String string = variableElement.getSimpleName().toString();
            if (this.getBindingManager().isParameterOfTypeTPCfy(variableElement.asType())) {
                String paramNameWithIndex = string + "_" + paramIndex;
                String stubName = paramNameWithIndex + "_stub";
                methodBuilder.addStatement("$T " + stubName + " = null", new Object[]{RPCStub.class});
                methodBuilder.beginControlFlow("if (" + paramNameWithIndex + " != null)", new Object[0]);
                methodBuilder.addStatement(stubName + " = rpcHandler.getStub(" + paramNameWithIndex + ")", new Object[0]);
                methodBuilder.beginControlFlow("if (" + stubName + " == null)", new Object[0]);
                methodBuilder.addStatement(stubName + " = new " + variableElement.asType() + "_JsonRpcStub" + "(rpcHandler, " + string + "_" + paramIndex + ", jsonify)", new Object[0]);
                methodBuilder.addStatement("rpcHandler.registerStub(" + stubName + ")", new Object[0]);
                methodBuilder.endControlFlow();
                methodBuilder.addStatement("paramsObject.put(\"" + string + "\", " + string + "_" + paramIndex + ".hashCode())", new Object[0]);
                methodBuilder.endControlFlow();
            } else {
                methodBuilder.addStatement("paramsObject.put(\"" + string + "\", jsonify.toJson(" + string + "_" + paramIndex + "))", new Object[0]);
            }
            ++paramIndex;
        }
        methodBuilder.addStatement("jsonRPCObject.put(\"params\", paramsObject)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"id\", rpcCallId)", new Object[0]);
        methodBuilder.addStatement("$T<String, String> _jsonrpc_req_extras = rpcHandler.getExtras()", new Object[]{Map.class});
        methodBuilder.beginControlFlow("if (_jsonrpc_req_extras != null)", new Object[0]);
        methodBuilder.beginControlFlow("for (String key:_jsonrpc_req_extras.keySet())", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.putJson(key, _jsonrpc_req_extras.get(key))", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("if (this.customExtras != null)", new Object[0]);
        methodBuilder.beginControlFlow("for (String key:this.customExtras.keySet())", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.putJson(key, this.customExtras.get(key))", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        if (isOneWay) {
            methodBuilder.addStatement("rpcHandler.sendMessage(jsonRPCObject.toJson(), interfaceName, methodID, rpcCallId, proxyInstanceId, this)", new Object[0]);
        } else {
            methodBuilder.addStatement("String result", new Object[0]);
            methodBuilder.addStatement("result = rpcHandler.sendMessageAndWaitForResponse(jsonRPCObject.toJson(), interfaceName, methodID, rpcCallId, proxyInstanceId)", new Object[0]);
            methodBuilder.addStatement("String exception = jsonify.getJSONElement(result, \"error\")", new Object[0]);
            methodBuilder.beginControlFlow("if (exception != null)", new Object[0]);
            methodBuilder.addStatement("String exceptionClassName = jsonify.fromJSON(exception, \"exception\", String.class)", new Object[0]);
            methodBuilder.addStatement("String exceptionMessage = jsonify.fromJSON(exception, \"message\", String.class)", new Object[0]);
            int exceptionIndex = 0;
            for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
                methodBuilder.addStatement(typeMirror.toString() + " exception_" + exceptionIndex + " = JsonRPCMessageHandler.asException(exceptionClassName, exceptionMessage, " + typeMirror.toString() + ".class)", new Object[0]);
                methodBuilder.beginControlFlow("if (exception_" + exceptionIndex + " != null)", new Object[0]);
                methodBuilder.addStatement("throw exception_" + exceptionIndex, new Object[0]);
                methodBuilder.endControlFlow();
                ++exceptionIndex;
            }
            methodBuilder.addStatement("throw new RuntimeException(jsonify.getJSONElement(exception, \"message\"))", new Object[0]);
            methodBuilder.endControlFlow();
            String string = executableElement.getReturnType().toString();
            if (executableElement.getReturnType().getKind() == TypeKind.DECLARED) {
                methodBuilder.addStatement("$T genericType = new $T<" + string + ">(){}.getType()", new Object[]{Type.class, TypeToken.class});
                if (this.getBindingManager().isParameterOfTypeTPCfy(executableElement.getReturnType())) {
                    methodBuilder.addStatement("String resultJson = jsonify.getJSONElement(result, \"result\")", new Object[0]);
                    methodBuilder.beginControlFlow("if (resultJson != null && !resultJson.isEmpty())", new Object[0]);
                    methodBuilder.addStatement("int return_id = jsonify.fromJSON(resultJson, int.class)", new Object[0]);
                    ClassName className = ClassName.bestGuess((String)(executableElement.getReturnType().toString() + "_JsonRpcProxy"));
                    methodBuilder.addStatement("$T _remoteHandlerResultId = null", new Object[]{Integer.class});
                    methodBuilder.beginControlFlow("if (jsonify.getJSONElement(result, \"handler_id\") != null)", new Object[0]);
                    methodBuilder.addStatement("_remoteHandlerResultId = jsonify.fromJSON(result, \"handler_id\", int.class)", new Object[0]);
                    methodBuilder.endControlFlow();
                    methodBuilder.addStatement("return new $T(rpcHandler, jsonify, return_id, _remoteHandlerResultId)", new Object[]{className});
                    methodBuilder.endControlFlow();
                    methodBuilder.beginControlFlow("else", new Object[0]);
                    methodBuilder.addStatement("return null", new Object[0]);
                    methodBuilder.endControlFlow();
                } else {
                    methodBuilder.addStatement("return jsonify.fromJSON(result, \"result\", genericType)", new Object[0]);
                }
            } else {
                methodBuilder.addStatement("return jsonify.fromJSON(result, \"result\", " + string + ".class)", new Object[0]);
            }
        }
        classBuilder.addMethod(methodBuilder.build());
    }

    public void addStubMethods(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onRPCCall").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addParameter(Integer.TYPE, "methodID", new Modifier[0]).addParameter(String.class, "message", new Modifier[0]);
        methodBuilder.addStatement("$T rpc_method_delegate = null", new Object[]{RPCMethodDelegate.class});
        methodBuilder.addStatement("$T customExtras = null", new Object[]{ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class})});
        methodBuilder.addStatement("$T jsonRPCObject = jsonify.newJson()", new Object[]{JSONify.JObject.class});
        methodBuilder.addStatement("jsonRPCObject.put(\"jsonrpc\", \"2.0\")", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"interface\", getStubInterfaceName())", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"method_id\", methodID)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"id\", jsonify.fromJSON(message, \"id\", int.class))", new Object[0]);
        methodBuilder.beginControlFlow("if (jsonify.getJSONElement(message, \"ins_id\") != null)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"ins_id\", jsonify.fromJSON(message, \"ins_id\", int.class))", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("$T _remoteHandlerId = null", new Object[]{Integer.class});
        methodBuilder.beginControlFlow("if (jsonify.getJSONElement(message, \"handler_id\") != null)", new Object[0]);
        methodBuilder.addStatement("_remoteHandlerId = jsonify.fromJSON(message, \"handler_id\", int.class)", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"r_handler_id\", jsonify.fromJSON(message, \"handler_id\", int.class))", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("jsonRPCObject.put(\"handler_id\", rpcHandler.hashCode())", new Object[0]);
        methodBuilder.addStatement("$T requestElement = jsonify.fromJson(message)", new Object[]{JSONify.JElement.class});
        methodBuilder.addStatement("$T<String> requestParams = requestElement.getKeys()", new Object[]{Set.class});
        methodBuilder.beginControlFlow("if (requestParams != null)", new Object[0]);
        methodBuilder.addStatement("Map<String, String> _allParams = new $T<>()", new Object[]{HashMap.class});
        methodBuilder.beginControlFlow("for (String key : requestElement.getKeys())", new Object[0]);
        methodBuilder.addStatement("String _custom_value = requestElement.getStringValue(key)", new Object[0]);
        methodBuilder.addStatement("_allParams.put(key, _custom_value)", new Object[0]);
        methodBuilder.beginControlFlow("if (key.startsWith(\"custom_\"))", new Object[0]);
        methodBuilder.beginControlFlow("if (customExtras == null)", new Object[0]);
        methodBuilder.addStatement("customExtras = new $T<>()", new Object[]{HashMap.class});
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("jsonRPCObject.putJson(key, _custom_value)", new Object[0]);
        methodBuilder.addStatement("customExtras.put(key, _custom_value)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("rpcHandler.onRPCParameters(_allParams)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("try", new Object[0]);
        methodBuilder.beginControlFlow("switch (methodID)", new Object[0]);
        this.processRemoterElements(classBuilder, new RpcfyBuilder.ElementVisitor(){

            @Override
            public void visitElement(TypeSpec.Builder classBuilder, Element member, int methodIndex, MethodSpec.Builder methodBuilder) {
                MethodBuilder.this.addStubMethods(classBuilder, member, methodIndex, methodBuilder);
            }
        }, methodBuilder);
        methodBuilder.endControlFlow();
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("catch ($T re)", new Object[]{Throwable.class});
        methodBuilder.addStatement("JSONify.JObject jsonErrorObject = jsonify.newJson()", new Object[0]);
        methodBuilder.addStatement("jsonErrorObject.put(\"code\", -32000)", new Object[0]);
        methodBuilder.addStatement("jsonErrorObject.put(\"message\", re.getMessage())", new Object[0]);
        methodBuilder.addStatement("jsonErrorObject.put(\"exception\", re.getClass().getName())", new Object[0]);
        methodBuilder.addStatement("jsonRPCObject.put(\"error\", jsonErrorObject)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.beginControlFlow("if (rpc_method_delegate != null)", new Object[0]);
        methodBuilder.addStatement("rpcHandler.setOriginalMessage(rpc_method_delegate, null)", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("return jsonRPCObject.toJson()", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        this.addStubExtras(classBuilder);
    }

    private void addStubMethods(TypeSpec.Builder classBuilder, Element member, int methodIndex, MethodSpec.Builder methodBuilder) {
        ExecutableElement executableElement = (ExecutableElement)member;
        String methodName = executableElement.getSimpleName().toString();
        boolean isOneWay = executableElement.getReturnType().getKind() == TypeKind.VOID;
        methodBuilder.beginControlFlow("case METHOD_" + methodName + "_" + methodIndex + ":", new Object[0]);
        ArrayList<String> paramNames = new ArrayList<String>();
        int paramIndex = 0;
        methodBuilder.addStatement("String paramsElement = jsonify.getJSONElement(message, \"params\")", new Object[0]);
        for (VariableElement variableElement : executableElement.getParameters()) {
            String paramName = "arg_stb_" + paramIndex;
            if (this.getBindingManager().isParameterOfTypeTPCfy(variableElement.asType())) {
                ClassName proxy = ClassName.bestGuess((String)(variableElement.asType().toString() + "_JsonRpcProxy"));
                methodBuilder.addStatement("$T " + paramName + " = null", new Object[]{proxy});
                methodBuilder.addStatement("String " + paramName + "_id_json = jsonify.getJSONElement(paramsElement, \"" + variableElement.getSimpleName() + "\")", new Object[0]);
                methodBuilder.beginControlFlow("if (" + paramName + "_id_json != null)", new Object[0]);
                methodBuilder.addStatement("int " + paramName + "_id = jsonify.fromJSON(paramsElement, \"" + variableElement.getSimpleName() + "\", int.class)", new Object[0]);
                methodBuilder.addStatement(paramName + " = new $T(rpcHandler, jsonify, " + paramName + "_id, _remoteHandlerId)", new Object[]{proxy});
                methodBuilder.addStatement(paramName + ".setRPCfyCustomExtras(customExtras)", new Object[0]);
                methodBuilder.endControlFlow();
            } else {
                String pType = variableElement.asType().toString();
                if (variableElement.asType().getKind() == TypeKind.DECLARED) {
                    methodBuilder.addStatement("$T genericType" + paramIndex + " = new $T<" + pType + ">(){}.getType()", new Object[]{Type.class, TypeToken.class});
                    methodBuilder.addStatement("$T " + paramName + " = jsonify.fromJSON(paramsElement, \"" + variableElement.getSimpleName() + "\", genericType" + paramIndex + ")", new Object[]{variableElement.asType()});
                } else {
                    methodBuilder.addStatement("$T " + paramName + " = jsonify.fromJSON(paramsElement, \"" + variableElement.getSimpleName() + "\", $T.class)", new Object[]{variableElement.asType(), variableElement.asType()});
                }
            }
            paramNames.add(paramName);
            ++paramIndex;
        }
        methodBuilder.addStatement(this.getRemoterInterfaceClassName() + " methodImpl = service", new Object[0]);
        methodBuilder.addStatement("rpc_method_delegate = new $T(" + this.getRemoterInterfaceClassName() + ".class, METHOD_" + methodName + "_" + methodIndex + ", null)", new Object[]{RPCMethodDelegate.class});
        methodBuilder.addStatement(this.getRemoterInterfaceClassName() + " methodDelegate = (" + this.getRemoterInterfaceClassName() + ")rpcHandler.getMethodDelegate(rpc_method_delegate)", new Object[0]);
        methodBuilder.beginControlFlow("if (methodDelegate != null)", new Object[0]);
        methodBuilder.addStatement("methodImpl =  methodDelegate", new Object[0]);
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("rpc_method_delegate.setInstanceId(methodImpl.hashCode())", new Object[0]);
        methodBuilder.addStatement("onDispatchTransaction(rpc_method_delegate)", new Object[0]);
        methodBuilder.addStatement("rpcHandler.setOriginalMessage(rpc_method_delegate, message)", new Object[0]);
        String methodCall = "methodImpl." + methodName + "(";
        int n = paramNames.size();
        for (int paramCount = 0; paramCount < n; ++paramCount) {
            methodCall = methodCall + (String)paramNames.get(paramCount);
            if (paramCount >= n - 1) continue;
            methodCall = methodCall + ", ";
        }
        methodCall = methodCall + ")";
        if (executableElement.getReturnType().getKind() != TypeKind.VOID) {
            methodBuilder.addStatement("$T result = " + methodCall, new Object[]{executableElement.getReturnType()});
            if (this.getBindingManager().isParameterOfTypeTPCfy(executableElement.getReturnType())) {
                methodBuilder.addStatement("$T returnStub = null", new Object[]{RPCStub.class});
                methodBuilder.beginControlFlow("if (result  != null)", new Object[0]);
                methodBuilder.addStatement("returnStub = rpcHandler.getStub(result)", new Object[0]);
                methodBuilder.beginControlFlow("if (returnStub  == null)", new Object[0]);
                methodBuilder.addStatement("returnStub = new " + executableElement.getReturnType() + "_JsonRpcStub" + "(rpcHandler, result, jsonify)", new Object[0]);
                methodBuilder.addStatement("rpcHandler.registerStub(returnStub)", new Object[0]);
                methodBuilder.endControlFlow();
                methodBuilder.addStatement("jsonRPCObject.put(\"result\", result.hashCode())", new Object[0]);
                methodBuilder.endControlFlow();
            } else {
                methodBuilder.addStatement("jsonRPCObject.put(\"result\", jsonify.toJson(result))", new Object[0]);
            }
        } else {
            methodBuilder.addStatement(methodCall, new Object[0]);
            methodBuilder.addStatement("jsonRPCObject.put(\"result\", \"\")", new Object[0]);
        }
        methodBuilder.endControlFlow();
        methodBuilder.addStatement("break", new Object[0]);
    }

    private void addStubExtras(TypeSpec.Builder classBuilder) {
        this.addRPCStubMethods(classBuilder);
    }

    private void addRPCStubMethods(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getStubInterfaceName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return " + this.getRemoterInterfaceClassName() + ".class.getName()", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"getStubId").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Integer.TYPE).addStatement("return remoteID", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"getService").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Object.class).addStatement("return service", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"onDispatchTransaction").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(RPCMethodDelegate.class, "methodDelegate", new Modifier[0]).addJavadoc("Override to intercept before stub method is called\n", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return \"" + this.getRemoterInterfaceClassName() + "_RpcStub [\" + remoteID + \":\" + rpcHandler.hashCode() + ']'", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }

    private void addProxyExtras(TypeSpec.Builder classBuilder) {
        this.addHashCode(classBuilder);
        this.addEquals(classBuilder);
        this.addRpcProxyMethods(classBuilder);
    }

    private void addRpcProxyMethods(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"setRPCfyCustomExtras").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addParameter((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), "customExtras", new Modifier[0]).addStatement("this.customExtras = customExtras", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"setRPCRemoteListener").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(RPCProxy.RemoteListener.class, "remoteListener", new Modifier[0]).addStatement("this.remoteListener = remoteListener", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"onRPCOneWayResult").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(String.class, "result", new Modifier[0]).beginControlFlow("if (remoteListener != null)", new Object[0]).addStatement("String exception = jsonify.getJSONElement(result, \"error\")", new Object[0]).beginControlFlow("if (exception != null)", new Object[0]).addStatement("int code = jsonify.fromJSON(exception, \"code\", int.class)", new Object[0]).addStatement("String exceptionMessage = \"Remote Exception\"", new Object[0]).beginControlFlow("if (code == -32001)", new Object[0]).addStatement("exceptionMessage = \"Remote stub not found\"", new Object[0]).endControlFlow().beginControlFlow("else", new Object[0]).addStatement("String exceptionClassName = jsonify.fromJSON(exception, \"exception\", String.class)", new Object[0]).addStatement("exceptionMessage = exceptionClassName + \" \" +jsonify.fromJSON(exception, \"message\", String.class)", new Object[0]).endControlFlow().addStatement("int methodID = jsonify.fromJSON(result, \"method_id\", int.class)", new Object[0]).addStatement("remoteListener.onRPCFailed(this, methodID, new $T(code == -32000 ? RPCException.Type.REMOTE_EXCEPTION : RPCException.Type.REMOTE_STUB_NOT_FOUND, exceptionMessage))", new Object[]{RPCException.class}).endControlFlow().endControlFlow();
        classBuilder.addMethod(methodBuilder.build());
        methodBuilder = MethodSpec.methodBuilder((String)"toString").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addStatement("return \"" + this.getRemoterInterfaceClassName() + "_RpcProxy [\" + super.hashCode() + \":\" + remoteHandlerID + \":\" + remoteID + ']'", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }

    private void addHashCode(TypeSpec.Builder classBuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"hashCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE).addAnnotation(Override.class).addStatement("int code = super.hashCode()", new Object[0]).beginControlFlow("if (remoteID != null || remoteHandlerID != null)", new Object[0]).addStatement("code = (remoteID != null) ? (17 * remoteID) : 0", new Object[0]).addStatement("code += (remoteHandlerID != null) ? (89 * remoteHandlerID) : 0", new Object[0]).endControlFlow().addStatement("return code", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }

    private void addEquals(TypeSpec.Builder classBuilder) {
        String interfaceName = this.getRemoterInterfaceClassName() + "_JsonRpcProxy";
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"equals").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get(Object.class), "obj", new Modifier[0]).returns(Boolean.TYPE).addAnnotation(Override.class).addStatement("return (obj instanceof " + interfaceName + ") && obj.hashCode() == hashCode() && ( (remoteID != null && remoteID.equals(((" + interfaceName + ") obj).remoteID)) || (remoteID == ((" + interfaceName + ") obj).remoteID)) && ( (remoteHandlerID != null && remoteHandlerID.equals(((" + interfaceName + ") obj).remoteHandlerID)) || (remoteHandlerID == ((" + interfaceName + ") obj).remoteHandlerID))", new Object[0]);
        classBuilder.addMethod(methodBuilder.build());
    }
}

