/*
 * Decompiled with CFR 0.152.
 */
package rpcfy.compiler.builder;

import com.google.auto.common.MoreElements;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import rpcfy.compiler.builder.BindingManager;

abstract class RpcfyBuilder {
    private Messager messager;
    private Element remoterInterfaceElement;
    private String remoterInterfacePackageName;
    private String remoterInterfaceClassName;
    private BindingManager bindingManager;

    protected RpcfyBuilder(Messager messager, Element remoterInterfaceElement) {
        this.messager = messager;
        this.remoterInterfaceElement = remoterInterfaceElement;
        if (remoterInterfaceElement != null) {
            this.remoterInterfacePackageName = MoreElements.getPackage((Element)remoterInterfaceElement).getQualifiedName().toString();
            this.remoterInterfaceClassName = remoterInterfaceElement.getSimpleName().toString();
        }
    }

    Element getRemoterInterfaceElement() {
        return this.remoterInterfaceElement;
    }

    String getRemoterInterfaceClassName() {
        return this.remoterInterfaceClassName;
    }

    String getRemteInterfaceFQName() {
        return this.getRemoterInterfacePackageName() + "." + this.getRemoterInterfaceClassName();
    }

    String getRemoterInterfacePackageName() {
        return this.remoterInterfacePackageName;
    }

    void logError(String message) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message);
    }

    void logWarning(String message) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, message);
    }

    void logInfo(String message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    BindingManager getBindingManager() {
        return this.bindingManager;
    }

    void setBindingManager(BindingManager bindingManager) {
        this.bindingManager = bindingManager;
    }

    protected void processRemoterElements(TypeSpec.Builder classBuilder, ElementVisitor elementVisitor, MethodSpec.Builder methodBuilder) {
        this.processRemoterElements(classBuilder, this.getRemoterInterfaceElement(), 0, elementVisitor, methodBuilder);
    }

    private int processRemoterElements(TypeSpec.Builder classBuilder, Element element, int methodIndex, ElementVisitor elementVisitor, MethodSpec.Builder methodBuilder) {
        if (element instanceof TypeElement) {
            for (TypeMirror typeMirror : ((TypeElement)element).getInterfaces()) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                Element superElement = ((DeclaredType)typeMirror).asElement();
                methodIndex = this.processRemoterElements(classBuilder, superElement, methodIndex, elementVisitor, methodBuilder);
            }
            for (Element element2 : element.getEnclosedElements()) {
                if (element2.getKind() != ElementKind.METHOD) continue;
                elementVisitor.visitElement(classBuilder, element2, methodIndex, methodBuilder);
                ++methodIndex;
            }
        }
        return methodIndex;
    }

    static interface ElementVisitor {
        public void visitElement(TypeSpec.Builder var1, Element var2, int var3, MethodSpec.Builder var4);
    }
}

