/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.feed;

import com.rometools.rome.feed.module.DCModuleImpl;
import com.rometools.rome.feed.synd.SyndEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class FeedRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    FeedRuntimeHintsRegistrar() {
    }

    private static Set<TypeReference> findClassesInPackage(String packageName, TypeFilter typeFilter) {
        ClassPathScanningCandidateComponentProvider classPathScanningCandidateComponentProvider = new ClassPathScanningCandidateComponentProvider(false);
        classPathScanningCandidateComponentProvider.addIncludeFilter(typeFilter);
        return classPathScanningCandidateComponentProvider.findCandidateComponents(packageName).stream().map(bd -> TypeReference.of((String)Objects.requireNonNull(bd.getBeanClassName()))).collect(Collectors.toUnmodifiableSet());
    }

    private static Set<TypeReference> findAnnotatedClassesInPackage(String packageName) {
        return FeedRuntimeHintsRegistrar.findClassesInPackage(packageName, (metadataReader, metadataReaderFactory) -> true);
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)"com.rometools.rome.feed.WireFeed", (ClassLoader)FeedRuntimeHintsRegistrar.class.getClassLoader())) {
            return;
        }
        MemberCategory[] mcs = MemberCategory.values();
        Set<TypeReference> classes = FeedRuntimeHintsRegistrar.findAnnotatedClassesInPackage("com.rometools.rome");
        for (TypeReference c : classes) {
            try {
                Class<?> cls = Class.forName(c.getName());
                if (!Serializable.class.isAssignableFrom(cls)) continue;
                this.log.info("register {} for reflection/serialization.", (Object)c.getName());
                hints.serialization().registerType(c);
                hints.reflection().registerType(c, mcs);
            }
            catch (ClassNotFoundException e) {
                this.log.warn("could not find the class {} and got the following exception: {}", (Object)c, (Object)e.toString());
            }
        }
        for (Class c : new Class[]{Date.class, SyndEntry.class, DCModuleImpl.class}) {
            hints.reflection().registerType(c, mcs);
        }
        ClassPathResource resource = new ClassPathResource("/com/rometools/rome/rome.properties");
        hints.resources().registerResource((Resource)resource);
        try (InputStream in = resource.getInputStream();){
            Properties props = new Properties();
            props.load(in);
            props.propertyNames().asIterator().forEachRemaining(pn -> {
                List<String> clz = FeedRuntimeHintsRegistrar.loadClasses((String)pn, props.getProperty((String)pn));
                clz.forEach(cn -> hints.reflection().registerType(TypeReference.of((String)cn), mcs));
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> loadClasses(String propertyName, String propertyValue) {
        String[] stringArray;
        Assert.hasText((String)propertyName, (String)"the propertyName must not be null");
        Assert.hasText((String)propertyValue, (String)"the propertyValue must not be null");
        if (propertyValue.contains(" ")) {
            stringArray = propertyValue.split(" ");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = propertyValue;
        }
        return Arrays.stream(stringArray).map(String::trim).filter(xValue -> !xValue.isBlank()).toList();
    }
}

