/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.git;

import com.joshlong.git.GitCallback;
import com.joshlong.git.GitTemplate;
import com.joshlong.git.PushCommandCreator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jgit.api.Git;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DefaultGitTemplate
implements GitTemplate {
    private final Git git;
    private final PushCommandCreator commandCreator;
    private final Log log = LogFactory.getLog(this.getClass());

    public DefaultGitTemplate(Git git, PushCommandCreator commandCreator) {
        this.git = git;
        this.commandCreator = commandCreator;
        Assert.notNull((Object)this.git, (String)("the " + Git.class.getName() + " reference can't be null"));
        Assert.notNull((Object)this.commandCreator, (String)("the " + PushCommandCreator.class.getName() + " reference can't be null"));
    }

    @Override
    public void execute(GitCallback gitCallback) {
        try {
            gitCallback.execute(this.git);
        }
        catch (Exception ex) {
            this.log.error((Object)ex);
            ReflectionUtils.rethrowRuntimeException((Throwable)ex);
        }
    }

    @Override
    public void executeAndPush(GitCallback callback) {
        try {
            this.execute(callback);
        }
        finally {
            try {
                this.commandCreator.createPushCommand(this.git).call();
            }
            catch (Throwable e) {
                this.log.error((Object)e);
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
        }
    }
}

