/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.git;

import com.joshlong.git.DefaultGitTemplate;
import com.joshlong.git.GitCallback;
import com.joshlong.git.GitProperties;
import com.joshlong.git.GitTemplate;
import com.joshlong.git.GitUtils;
import com.joshlong.git.PushCommandCreator;
import java.net.URI;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={GitProperties.class})
@ConditionalOnProperty(name={"git.enabled"}, havingValue="true", matchIfMissing=true)
public class GitTemplateAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GitTemplateAutoConfiguration.class);

    @Configuration
    @ConditionalOnProperty(name={"git.online"}, havingValue="true", matchIfMissing=true)
    public static class OnlineGitConfiguration {
        @Bean
        @ConditionalOnBean(value={Git.class})
        @ConditionalOnMissingBean
        GitTemplate gitService(Git git, PushCommandCreator commandCreator) {
            return new DefaultGitTemplate(git, commandCreator);
        }

        @Configuration
        @ConditionalOnProperty(name={"git.http.enabled"}, havingValue="true")
        public static class HttpConfig {
            private static final Logger log = LoggerFactory.getLogger(HttpConfig.class);

            @Bean
            @ConditionalOnMissingBean
            Git git(GitProperties gsp) {
                return GitUtils.createLocalHttpGitRepository(URI.create(gsp.getUri()), gsp.getLocalCloneDirectory());
            }

            @Bean
            @ConditionalOnMissingBean
            PushCommandCreator httpPushCommandCreator(GitProperties gsp) {
                GitProperties.Http http = gsp.getHttp();
                return GitUtils.createHttpPushCommandCreator(http.getUsername(), http.getPassword());
            }
        }

        @Configuration
        @ConditionalOnProperty(name={"git.ssh.enabled"}, havingValue="true")
        public static class SshConfig {
            @Bean
            @ConditionalOnMissingBean
            TransportConfigCallback transportConfigCallback(SshSessionFactory sshSessionFactory) {
                return GitUtils.createSshTransportConfigCallback(sshSessionFactory);
            }

            @Bean
            @ConditionalOnMissingBean
            SshSessionFactory sshSessionFactory(GitProperties properties) {
                String pw = properties.getSsh().getPassword();
                return GitUtils.createSshSessionFactory(pw);
            }

            @Bean
            @ConditionalOnMissingBean(value={Git.class})
            Git git(GitProperties gsp, TransportConfigCallback transportConfigCallback) throws GitAPIException {
                return GitUtils.createLocalSshGitRepository(URI.create(gsp.getUri()), gsp.getLocalCloneDirectory(), transportConfigCallback);
            }

            @Bean
            PushCommandCreator commandCreator(TransportConfigCallback transportConfigCallback) {
                return GitUtils.createSshPushCommandCreator(transportConfigCallback);
            }
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"git.online"}, havingValue="false")
    public static class OfflineGitConfiguration {
        @Bean
        GitTemplate gitTemplate() {
            return new NoOpGitTemplate();
        }

        private static class NoOpGitTemplate
        implements GitTemplate {
            private static final Logger log = LoggerFactory.getLogger(NoOpGitTemplate.class);
            private String name = NoOpGitTemplate.class.getName();

            private NoOpGitTemplate() {
            }

            @Override
            public void execute(GitCallback gitCallback) {
                log.info(this.name + "#execute(GitCallback)");
            }

            @Override
            public void executeAndPush(GitCallback callback) {
                log.info(this.name + "#executeAndPush(GitCallback)");
            }
        }
    }
}

