/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.git;

import com.jcraft.jsch.UserInfo;
import com.joshlong.git.PushCommandCreator;
import java.io.File;
import java.net.URI;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.FS;
import org.springframework.util.Assert;
import org.springframework.util.FileSystemUtils;

public abstract class GitUtils {
    public static TransportConfigCallback createSshTransportConfigCallback(SshSessionFactory sshSessionFactory) {
        return transport -> {
            Assert.isTrue((boolean)(transport instanceof SshTransport), (String)("the " + Transport.class.getName() + " must be an instance of " + SshTransport.class.getName()));
            SshTransport ssh = (SshTransport)SshTransport.class.cast(transport);
            ssh.setSshSessionFactory(sshSessionFactory);
        };
    }

    public static TransportConfigCallback createSshTransportConfigCallback(String pw) {
        SshSessionFactory sshSessionFactory = GitUtils.createSshSessionFactory(pw);
        return transport -> {
            Assert.isTrue((boolean)(transport instanceof SshTransport), (String)("the " + Transport.class.getName() + " must be an instance of " + SshTransport.class.getName()));
            SshTransport ssh = (SshTransport)SshTransport.class.cast(transport);
            ssh.setSshSessionFactory(sshSessionFactory);
        };
    }

    @Deprecated
    static SshSessionFactory createSshSessionFactory(final String pw) {
        UserInfo userinfo = new UserInfo(){

            public String getPassphrase() {
                return pw;
            }

            public String getPassword() {
                return null;
            }

            public boolean promptPassword(String s) {
                return false;
            }

            public boolean promptPassphrase(String s) {
                return false;
            }

            public boolean promptYesNo(String s) {
                return false;
            }

            public void showMessage(String s) {
            }
        };
        return new SshSessionFactory(){

            public RemoteSession getSession(URIish urIish, CredentialsProvider credentialsProvider, FS fs, int i) throws TransportException {
                return null;
            }

            public String getType() {
                return null;
            }
        };
    }

    public static PushCommandCreator createSshPushCommandCreator(TransportConfigCallback transportConfigCallback) {
        return git -> (PushCommand)git.push().setRemote("origin").setTransportConfigCallback(transportConfigCallback);
    }

    public static Git createLocalSshGitRepository(URI uri, File localCloneDirectory, TransportConfigCallback transportConfigCallback) throws GitAPIException {
        GitUtils.reset(localCloneDirectory);
        return ((CloneCommand)Git.cloneRepository().setTransportConfigCallback(transportConfigCallback)).setURI(uri.toASCIIString()).setDirectory(localCloneDirectory).call();
    }

    public static Git createLocalHttpGitRepository(URI uri, File localCloneDirectory) {
        GitUtils.reset(localCloneDirectory);
        return Git.cloneRepository().setURI(uri.toASCIIString()).setDirectory(localCloneDirectory).call();
    }

    public static PushCommandCreator createHttpPushCommandCreator(String user, String pw) {
        Assert.notNull((Object)user, (String)"http.username can't be null");
        Assert.notNull((Object)pw, (String)"http.password can't be null");
        return git -> (PushCommand)git.push().setRemote("origin").setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(user, pw));
    }

    private static void reset(File directory) {
        if (directory.exists()) {
            FileSystemUtils.deleteRecursively((File)directory);
        }
    }
}

