/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.lucene;

import com.joshlong.lucene.LuceneProperties;
import com.joshlong.lucene.LuceneTemplate;
import java.nio.file.Path;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.util.StringUtils;

@Configuration
@ImportRuntimeHints(value={LuceneHints.class})
@EnableConfigurationProperties(value={LuceneProperties.class})
class LuceneAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LuceneAutoConfiguration.class);

    LuceneAutoConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(value={"lucene.search.index-directory-resource"})
    @ConditionalOnMissingBean(value={LuceneTemplate.class})
    LuceneTemplate luceneTemplate(LuceneProperties properties, Analyzer analyzer) throws Exception {
        String defaultIndexField = properties.search().defaultIndexField();
        if (!StringUtils.hasText((String)defaultIndexField)) {
            defaultIndexField = "description";
        }
        return new LuceneTemplate(analyzer, defaultIndexField, (Directory)FSDirectory.open((Path)properties.search().indexDirectoryResource().getFile().toPath()));
    }

    @Bean
    @ConditionalOnMissingBean(value={Analyzer.class})
    Analyzer analyzer() {
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                StandardTokenizer tokenizer = new StandardTokenizer();
                tokenizer.setMaxTokenLength(255);
                StopFilter filters = new StopFilter((TokenStream)new ASCIIFoldingFilter((TokenStream)new LowerCaseFilter((TokenStream)tokenizer)), CharArraySet.EMPTY_SET);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)filters);
            }
        };
    }

    static class LuceneHints
    implements RuntimeHintsRegistrar {
        LuceneHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.reflection().registerType(PackedTokenAttributeImpl.class, MemberCategory.values());
        }
    }
}

