/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.lucene;

import com.joshlong.lucene.DocumentSearchMapper;
import com.joshlong.lucene.DocumentWriteMapper;
import com.joshlong.lucene.IndexWriterCallback;
import com.joshlong.lucene.LuceneOperations;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class LuceneTemplate
implements LuceneOperations {
    private static final Logger log = LoggerFactory.getLogger(LuceneTemplate.class);
    private final Analyzer analyzer;
    private final Object monitor = new Object();
    private final Directory indexDirectory;
    private final String defaultIndexField;
    private final AtomicReference<IndexReader> reader = new AtomicReference();
    private final AtomicReference<IndexSearcher> searcher = new AtomicReference();

    public LuceneTemplate(Analyzer analyzer, String defaultIndexField, Directory directory) {
        this.analyzer = analyzer;
        this.indexDirectory = directory;
        this.defaultIndexField = defaultIndexField;
    }

    private IndexReader buildIndexReader() {
        return DirectoryReader.open((Directory)this.indexDirectory);
    }

    private IndexWriter buildIndexWriter() {
        IndexWriterConfig iwc = new IndexWriterConfig(this.analyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return new IndexWriter(this.indexDirectory, iwc);
    }

    private IndexSearcher buildIndexSearcher(IndexReader reader) {
        return new IndexSearcher(reader);
    }

    @Override
    public <T> void write(Iterable<T> listOfItems, DocumentWriteMapper<T> mapper) {
        Assert.notNull(listOfItems, () -> "the collection should be non-null");
        this.write(iw -> {
            for (Object item : listOfItems) {
                DocumentWriteMapper.DocumentWrite write = mapper.map(item);
                iw.updateDocument(write.getTerm(), (Iterable)write.getDocument());
            }
        });
    }

    @Override
    public void write(IndexWriterCallback callback) {
        try (IndexWriter iw = this.buildIndexWriter();){
            callback.executeWithIndexWriter(iw);
        }
        catch (Exception exception) {
            ReflectionUtils.rethrowRuntimeException((Throwable)exception);
        }
    }

    @Override
    public <T> List<T> search(Query query, int maxResults, DocumentSearchMapper<T> mapper) {
        TopDocs search = this.search(query, maxResults);
        ArrayList<T> results = new ArrayList<T>();
        for (ScoreDoc sd : search.scoreDocs) {
            Document doc = this.searcher.get().doc(sd.doc);
            T map = mapper.map(doc);
            results.add(map);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TopDocs search(Query q, int max) {
        if (this.reader.get() == null) {
            Object object = this.monitor;
            synchronized (object) {
                this.reader.set(this.buildIndexReader());
                this.searcher.set(this.buildIndexSearcher(this.reader.get()));
            }
        }
        IndexSearcher indexSearcher = this.searcher.get();
        return indexSearcher.search(q, max);
    }

    @Override
    public <T> List<T> search(String query, int max, DocumentSearchMapper<T> mapper) {
        return this.search(this.buildQueryParserFor(this.defaultIndexField, query), max, mapper);
    }

    private Query buildQueryParserFor(String field, String queryStr) throws Exception {
        QueryParser qp = new QueryParser(field, this.analyzer);
        return qp.parse(queryStr);
    }
}

