/*
 * Decompiled with CFR 0.152.
 */
package com.joshlong.templates;

import com.joshlong.templates.MarkdownService;
import com.joshlong.templates.MustacheService;
import com.joshlong.templates.TemplateProperties;
import com.samskivert.mustache.Mustache;
import java.nio.charset.Charset;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={TemplateProperties.class})
@ImportRuntimeHints(value={TemplateHints.class})
public class TemplateAutoConfiguration {
    private final Charset charset;

    public TemplateAutoConfiguration(TemplateProperties templateProperties) {
        String charset = templateProperties.charset();
        this.charset = !StringUtils.hasText((String)charset) ? Charset.defaultCharset() : Charset.forName(charset);
    }

    @Bean
    MarkdownService markdownService() {
        return new MarkdownService(Parser.builder().build(), HtmlRenderer.builder().build());
    }

    @Bean
    MustacheService mustacheService(Mustache.Compiler compiler) {
        return new MustacheService(compiler, this.charset);
    }

    static class TemplateHints
    implements RuntimeHintsRegistrar {
        TemplateHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            ClassPathResource classPathResource = new ClassPathResource("org/commonmark/internal/util/entities.properties");
            hints.resources().registerResource((Resource)classPathResource);
        }
    }
}

