/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.camera.open;

import android.hardware.Camera;
import android.util.Log;

public final class OpenCameraInterface {
    private static final String TAG = OpenCameraInterface.class.getName();
    public static final int NO_REQUESTED_CAMERA = -1;

    private OpenCameraInterface() {
    }

    public static int getCameraId(int requestedId) {
        boolean explicitRequest;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            Log.w((String)TAG, (String)"No cameras!");
            return -1;
        }
        int cameraId = requestedId;
        boolean bl = explicitRequest = cameraId >= 0;
        if (!explicitRequest) {
            int index;
            for (index = 0; index < numCameras; ++index) {
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing == 0) break;
            }
            cameraId = index;
        }
        if (cameraId < numCameras) {
            return cameraId;
        }
        if (explicitRequest) {
            return -1;
        }
        return 0;
    }

    public static Camera open(int requestedId) {
        int cameraId = OpenCameraInterface.getCameraId(requestedId);
        if (cameraId == -1) {
            return null;
        }
        return Camera.open((int)cameraId);
    }
}

