/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.content.Intent;

public final class ScanIntentResult {
    private final String contents;
    private final String formatName;
    private final byte[] rawBytes;
    private final Integer orientation;
    private final String errorCorrectionLevel;
    private final String barcodeImagePath;
    private final Intent originalIntent;

    ScanIntentResult() {
        this(null, null, null, null, null, null, null);
    }

    ScanIntentResult(Intent intent) {
        this(null, null, null, null, null, null, intent);
    }

    ScanIntentResult(String contents, String formatName, byte[] rawBytes, Integer orientation, String errorCorrectionLevel, String barcodeImagePath, Intent originalIntent) {
        this.contents = contents;
        this.formatName = formatName;
        this.rawBytes = rawBytes;
        this.orientation = orientation;
        this.errorCorrectionLevel = errorCorrectionLevel;
        this.barcodeImagePath = barcodeImagePath;
        this.originalIntent = originalIntent;
    }

    public String getContents() {
        return this.contents;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public Integer getOrientation() {
        return this.orientation;
    }

    public String getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public String getBarcodeImagePath() {
        return this.barcodeImagePath;
    }

    public Intent getOriginalIntent() {
        return this.originalIntent;
    }

    public String toString() {
        int rawBytesLength = this.rawBytes == null ? 0 : this.rawBytes.length;
        return "Format: " + this.formatName + '\n' + "Contents: " + this.contents + '\n' + "Raw bytes: (" + rawBytesLength + " bytes)\nOrientation: " + this.orientation + '\n' + "EC level: " + this.errorCorrectionLevel + '\n' + "Barcode image: " + this.barcodeImagePath + '\n' + "Original intent: " + this.originalIntent + '\n';
    }

    public static ScanIntentResult parseActivityResult(int resultCode, Intent intent) {
        if (resultCode == -1) {
            String contents = intent.getStringExtra("SCAN_RESULT");
            String formatName = intent.getStringExtra("SCAN_RESULT_FORMAT");
            byte[] rawBytes = intent.getByteArrayExtra("SCAN_RESULT_BYTES");
            int intentOrientation = intent.getIntExtra("SCAN_RESULT_ORIENTATION", Integer.MIN_VALUE);
            Integer orientation = intentOrientation == Integer.MIN_VALUE ? null : Integer.valueOf(intentOrientation);
            String errorCorrectionLevel = intent.getStringExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL");
            String barcodeImagePath = intent.getStringExtra("SCAN_RESULT_IMAGE_PATH");
            return new ScanIntentResult(contents, formatName, rawBytes, orientation, errorCorrectionLevel, barcodeImagePath, intent);
        }
        return new ScanIntentResult(intent);
    }
}

