/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner.camera;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import com.google.zxing.client.android.AmbientLightManager;
import com.google.zxing.client.android.camera.open.OpenCameraInterface;
import com.journeyapps.barcodescanner.Size;
import com.journeyapps.barcodescanner.SourceData;
import com.journeyapps.barcodescanner.camera.AutoFocusManager;
import com.journeyapps.barcodescanner.camera.CameraConfigurationUtils;
import com.journeyapps.barcodescanner.camera.CameraParametersCallback;
import com.journeyapps.barcodescanner.camera.CameraSettings;
import com.journeyapps.barcodescanner.camera.CameraSurface;
import com.journeyapps.barcodescanner.camera.DisplayConfiguration;
import com.journeyapps.barcodescanner.camera.PreviewCallback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private Camera camera;
    private Camera.CameraInfo cameraInfo;
    private AutoFocusManager autoFocusManager;
    private AmbientLightManager ambientLightManager;
    private boolean previewing;
    private String defaultParameters;
    private CameraSettings settings = new CameraSettings();
    private DisplayConfiguration displayConfiguration;
    private Size requestedPreviewSize;
    private Size previewSize;
    private int rotationDegrees = -1;
    private Context context;
    private final CameraPreviewCallback cameraPreviewCallback;

    public CameraManager(Context context) {
        this.context = context;
        this.cameraPreviewCallback = new CameraPreviewCallback();
    }

    public void open() {
        this.camera = OpenCameraInterface.open(this.settings.getRequestedCameraId());
        if (this.camera == null) {
            throw new RuntimeException("Failed to open camera");
        }
        int cameraId = OpenCameraInterface.getCameraId(this.settings.getRequestedCameraId());
        this.cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)this.cameraInfo);
    }

    public void configure() {
        if (this.camera == null) {
            throw new RuntimeException("Camera not open");
        }
        this.setParameters();
    }

    public void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        this.setPreviewDisplay(new CameraSurface(holder));
    }

    public void setPreviewDisplay(CameraSurface surface) throws IOException {
        surface.setPreview(this.camera);
    }

    public void startPreview() {
        Camera theCamera = this.camera;
        if (theCamera != null && !this.previewing) {
            theCamera.startPreview();
            this.previewing = true;
            this.autoFocusManager = new AutoFocusManager(this.camera, this.settings);
            this.ambientLightManager = new AmbientLightManager(this.context, this, this.settings);
            this.ambientLightManager.start();
        }
    }

    public void stopPreview() {
        if (this.autoFocusManager != null) {
            this.autoFocusManager.stop();
            this.autoFocusManager = null;
        }
        if (this.ambientLightManager != null) {
            this.ambientLightManager.stop();
            this.ambientLightManager = null;
        }
        if (this.camera != null && this.previewing) {
            this.camera.stopPreview();
            this.cameraPreviewCallback.setCallback(null);
            this.previewing = false;
        }
    }

    public void close() {
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
    }

    public boolean isCameraRotated() {
        if (this.rotationDegrees == -1) {
            throw new IllegalStateException("Rotation not calculated yet. Call configure() first.");
        }
        return this.rotationDegrees % 180 != 0;
    }

    public int getCameraRotation() {
        return this.rotationDegrees;
    }

    private Camera.Parameters getDefaultCameraParameters() {
        Camera.Parameters parameters = this.camera.getParameters();
        if (this.defaultParameters == null) {
            this.defaultParameters = parameters.flatten();
        } else {
            parameters.unflatten(this.defaultParameters);
        }
        return parameters;
    }

    private void setDesiredParameters(boolean safeMode) {
        List<Size> previewSizes;
        Camera.Parameters parameters = this.getDefaultCameraParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (safeMode) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        CameraConfigurationUtils.setFocus(parameters, this.settings.getFocusMode(), safeMode);
        if (!safeMode) {
            CameraConfigurationUtils.setTorch(parameters, false);
            if (this.settings.isScanInverted()) {
                CameraConfigurationUtils.setInvertColor(parameters);
            }
            if (this.settings.isBarcodeSceneModeEnabled()) {
                CameraConfigurationUtils.setBarcodeSceneMode(parameters);
            }
            if (this.settings.isMeteringEnabled()) {
                CameraConfigurationUtils.setVideoStabilization(parameters);
                CameraConfigurationUtils.setFocusArea(parameters);
                CameraConfigurationUtils.setMetering(parameters);
            }
        }
        if ((previewSizes = CameraManager.getPreviewSizes(parameters)).size() == 0) {
            this.requestedPreviewSize = null;
        } else {
            this.requestedPreviewSize = this.displayConfiguration.getBestPreviewSize(previewSizes, this.isCameraRotated());
            parameters.setPreviewSize(this.requestedPreviewSize.width, this.requestedPreviewSize.height);
        }
        if (Build.DEVICE.equals("glass-1")) {
            CameraConfigurationUtils.setBestPreviewFPS(parameters);
        }
        Log.i((String)TAG, (String)("Final camera parameters: " + parameters.flatten()));
        this.camera.setParameters(parameters);
    }

    private static List<Size> getPreviewSizes(Camera.Parameters parameters) {
        List rawSupportedSizes = parameters.getSupportedPreviewSizes();
        ArrayList<Size> previewSizes = new ArrayList<Size>();
        if (rawSupportedSizes == null) {
            Camera.Size defaultSize = parameters.getPreviewSize();
            if (defaultSize != null) {
                Size previewSize = new Size(defaultSize.width, defaultSize.height);
                previewSizes.add(new Size(defaultSize.width, defaultSize.height));
            }
            return previewSizes;
        }
        for (Camera.Size size : rawSupportedSizes) {
            previewSizes.add(new Size(size.width, size.height));
        }
        return previewSizes;
    }

    private int calculateDisplayRotation() {
        int result;
        int rotation = this.displayConfiguration.getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (this.cameraInfo.facing == 1) {
            result = (this.cameraInfo.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (this.cameraInfo.orientation - degrees + 360) % 360;
        }
        Log.i((String)TAG, (String)("Camera Display Orientation: " + result));
        return result;
    }

    private void setCameraDisplayOrientation(int rotation) {
        this.camera.setDisplayOrientation(rotation);
    }

    private void setParameters() {
        try {
            this.rotationDegrees = this.calculateDisplayRotation();
            this.setCameraDisplayOrientation(this.rotationDegrees);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to set rotation.");
        }
        try {
            this.setDesiredParameters(false);
        }
        catch (Exception e) {
            try {
                this.setDesiredParameters(true);
            }
            catch (Exception e2) {
                Log.w((String)TAG, (String)"Camera rejected even safe-mode parameters! No configuration");
            }
        }
        Camera.Size realPreviewSize = this.camera.getParameters().getPreviewSize();
        this.previewSize = realPreviewSize == null ? this.requestedPreviewSize : new Size(realPreviewSize.width, realPreviewSize.height);
        this.cameraPreviewCallback.setResolution(this.previewSize);
    }

    public boolean isOpen() {
        return this.camera != null;
    }

    public Size getNaturalPreviewSize() {
        return this.previewSize;
    }

    public Size getPreviewSize() {
        if (this.previewSize == null) {
            return null;
        }
        if (this.isCameraRotated()) {
            return this.previewSize.rotate();
        }
        return this.previewSize;
    }

    public void requestPreviewFrame(PreviewCallback callback) {
        Camera theCamera = this.camera;
        if (theCamera != null && this.previewing) {
            this.cameraPreviewCallback.setCallback(callback);
            theCamera.setOneShotPreviewCallback((Camera.PreviewCallback)this.cameraPreviewCallback);
        }
    }

    public CameraSettings getCameraSettings() {
        return this.settings;
    }

    public void setCameraSettings(CameraSettings settings) {
        this.settings = settings;
    }

    public DisplayConfiguration getDisplayConfiguration() {
        return this.displayConfiguration;
    }

    public void setDisplayConfiguration(DisplayConfiguration displayConfiguration) {
        this.displayConfiguration = displayConfiguration;
    }

    public void setTorch(boolean on) {
        if (this.camera != null) {
            try {
                boolean isOn = this.isTorchOn();
                if (on != isOn) {
                    if (this.autoFocusManager != null) {
                        this.autoFocusManager.stop();
                    }
                    Camera.Parameters parameters = this.camera.getParameters();
                    CameraConfigurationUtils.setTorch(parameters, on);
                    if (this.settings.isExposureEnabled()) {
                        CameraConfigurationUtils.setBestExposure(parameters, on);
                    }
                    this.camera.setParameters(parameters);
                    if (this.autoFocusManager != null) {
                        this.autoFocusManager.start();
                    }
                }
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Failed to set torch", (Throwable)e);
            }
        }
    }

    public void changeCameraParameters(CameraParametersCallback callback) {
        if (this.camera != null) {
            try {
                this.camera.setParameters(callback.changeCameraParameters(this.camera.getParameters()));
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Failed to change camera parameters", (Throwable)e);
            }
        }
    }

    public boolean isTorchOn() {
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters != null) {
            String flashMode = parameters.getFlashMode();
            return flashMode != null && ("on".equals(flashMode) || "torch".equals(flashMode));
        }
        return false;
    }

    public Camera getCamera() {
        return this.camera;
    }

    private final class CameraPreviewCallback
    implements Camera.PreviewCallback {
        private PreviewCallback callback;
        private Size resolution;

        public void setResolution(Size resolution) {
            this.resolution = resolution;
        }

        public void setCallback(PreviewCallback callback) {
            this.callback = callback;
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            Size cameraResolution = this.resolution;
            PreviewCallback callback = this.callback;
            if (cameraResolution != null && callback != null) {
                try {
                    if (data == null) {
                        throw new NullPointerException("No preview data received");
                    }
                    int format = camera.getParameters().getPreviewFormat();
                    SourceData source = new SourceData(data, cameraResolution.width, cameraResolution.height, format, CameraManager.this.getCameraRotation());
                    if (((CameraManager)CameraManager.this).cameraInfo.facing == 1) {
                        source.setPreviewMirrored(true);
                    }
                    callback.onPreview(source);
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)"Camera preview failed", (Throwable)e);
                    callback.onPreviewError(e);
                }
            } else {
                Log.d((String)TAG, (String)"Got preview callback, but no handler or resolution available");
                if (callback != null) {
                    callback.onPreviewError(new Exception("No resolution available"));
                }
            }
        }
    }
}

