/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.apache.httpclient;

import com.joyent.http.signature.HttpSignatureException;
import com.joyent.http.signature.Signer;
import com.joyent.http.signature.ThreadLocalSigner;
import java.security.KeyPair;
import java.util.Locale;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class HttpSignatureAuthScheme
implements ContextAwareAuthScheme {
    public static final String SCHEME_NAME = "Signatures";
    private static final Log LOG = LogFactory.getLog(HttpSignatureAuthScheme.class);
    private final KeyPair keyPair;
    private final ThreadLocal<Signer> signer;

    public HttpSignatureAuthScheme(KeyPair keyPair, boolean useNativeCodeToSign) {
        if (keyPair == null) {
            throw new IllegalArgumentException("KeyPair must be present");
        }
        this.keyPair = keyPair;
        this.signer = new ThreadLocalSigner(useNativeCodeToSign);
    }

    public HttpSignatureAuthScheme(KeyPair keyPair) {
        if (keyPair == null) {
            throw new IllegalArgumentException("KeyPair must be present");
        }
        this.keyPair = keyPair;
        this.signer = new ThreadLocalSigner();
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public String getParameter(String name) {
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public boolean isComplete() {
        return true;
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        UUID requestId = UUID.randomUUID();
        request.setHeader("x-request-id", requestId.toString());
        return this.signRequestHeader(credentials, request);
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }

    public String toString() {
        return this.getSchemeName().toUpperCase(Locale.ROOT);
    }

    protected Header signRequestHeader(Credentials credentials, HttpRequest request) throws AuthenticationException {
        String authz;
        String stringDate;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Signing request: %s", request));
        }
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials must be present");
        }
        if (credentials.getPassword() == null) {
            throw new IllegalArgumentException("Password (RSA fingerprint) must be present");
        }
        if (credentials.getUserPrincipal() == null) {
            throw new IllegalArgumentException("User principal must be present");
        }
        if (credentials.getUserPrincipal().getName() == null) {
            throw new IllegalArgumentException("User principal name must be present");
        }
        String login = credentials.getUserPrincipal().getName();
        String fingerprint = credentials.getPassword();
        Header date = request.getFirstHeader("Date");
        if (date != null) {
            stringDate = date.getValue();
        } else {
            stringDate = this.signer.get().defaultSignDateAsString();
            request.setHeader("Date", stringDate);
        }
        try {
            authz = this.signer.get().createAuthorizationHeader(login, fingerprint, this.keyPair, stringDate);
        }
        catch (HttpSignatureException e) {
            String details = String.format("Unable to authenticate [%s] with fingerprint [%s] using keypair [%s]", login, fingerprint, this.keyPair);
            throw new AuthenticationException(details, (Throwable)e);
        }
        BasicHeader authzHeader = new BasicHeader("Authorization", authz);
        return authzHeader;
    }
}

