/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.http.signature.apache.httpclient;

import com.joyent.http.signature.apache.httpclient.HttpSignatureAuthScheme;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.config.Lookup;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class HttpSignatureAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Log LOG = LogFactory.getLog(HttpSignatureAuthScheme.class);
    private final Map<String, Header> allChallenges;
    private final AuthOption authOption;

    public HttpSignatureAuthenticationStrategy(Lookup<AuthSchemeProvider> authSchemeProviderLookup, Credentials credentials) {
        this(((AuthSchemeProvider)authSchemeProviderLookup.lookup("Signatures")).create(null), credentials);
    }

    public HttpSignatureAuthenticationStrategy(AuthScheme authScheme, Credentials credentials) {
        this.authOption = new AuthOption(authScheme, credentials);
        HashMap<String, BasicHeader> temp = new HashMap<String, BasicHeader>(1);
        temp.put("Signatures", new BasicHeader("Authorization", "Signatures"));
        this.allChallenges = Collections.unmodifiableMap(temp);
    }

    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response, HttpContext context) {
        StatusLine line = response.getStatusLine();
        if (line.getStatusCode() == 401) {
            return true;
        }
        String key = "http.auth.target-scope";
        Object contextAuthState = context.getAttribute("http.auth.target-scope");
        if (contextAuthState == null) {
            return true;
        }
        AuthState authState = (AuthState)contextAuthState;
        return authState.getState().equals((Object)AuthProtocolState.UNCHALLENGED);
    }

    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        return this.allChallenges;
    }

    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        LinkedList<AuthOption> queue = new LinkedList<AuthOption>();
        queue.add(this.authOption);
        return queue;
    }

    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        LOG.debug((Object)"HTTP Signature authentication succeeded");
    }

    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        LOG.debug((Object)"HTTP Signature authentication failed");
    }
}

