/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.issue.Issue;
import com.jparams.object.builder.issue.IssueType;
import com.jparams.object.builder.utils.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

public class Build<T> {
    private final T obj;
    private final List<Issue> issues;

    public Build(T obj, List<Issue> issues) {
        this.obj = obj;
        this.issues = CollectionUtils.unmodifiableCopy(issues);
    }

    public T get() {
        return this.obj;
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public List<Issue> getErrors() {
        return this.issues.stream().filter(issue -> issue.getIssueType() == IssueType.ERROR).collect(Collectors.toList());
    }

    public List<Issue> getWarnings() {
        return this.issues.stream().filter(issue -> issue.getIssueType() == IssueType.WARNING).collect(Collectors.toList());
    }
}

