/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.ObjectFactory;
import com.jparams.object.builder.path.PathFilter;
import com.jparams.object.builder.provider.ArrayProvider;
import com.jparams.object.builder.provider.BigDecimalProvider;
import com.jparams.object.builder.provider.BooleanProvider;
import com.jparams.object.builder.provider.ByteProvider;
import com.jparams.object.builder.provider.CachedDataProvider;
import com.jparams.object.builder.provider.CharProvider;
import com.jparams.object.builder.provider.DateProvider;
import com.jparams.object.builder.provider.DoubleProvider;
import com.jparams.object.builder.provider.EnumProvider;
import com.jparams.object.builder.provider.FloatProvider;
import com.jparams.object.builder.provider.IntegerProvider;
import com.jparams.object.builder.provider.InterfaceProxyProvider;
import com.jparams.object.builder.provider.ListProvider;
import com.jparams.object.builder.provider.LocalDateProvider;
import com.jparams.object.builder.provider.LocalDateTimeProvider;
import com.jparams.object.builder.provider.LocalTimeProvider;
import com.jparams.object.builder.provider.LongProvider;
import com.jparams.object.builder.provider.MapProvider;
import com.jparams.object.builder.provider.NullProvider;
import com.jparams.object.builder.provider.ObjectProvider;
import com.jparams.object.builder.provider.OffsetDateTimeProvider;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.provider.SetProvider;
import com.jparams.object.builder.provider.StringProvider;
import com.jparams.object.builder.provider.ZonedDateTimeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Configuration {
    private final List<Provider> providers = new ArrayList<Provider>();
    private PathFilter pathFilter = path -> true;
    private Provider nullProvider = new NullProvider();
    private int maxDepth = 15;
    private boolean caching = false;
    private int cacheStart = 0;
    private boolean failOnError = true;
    private boolean failOnWarning = false;

    public Configuration withMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public Configuration withPathFilter(PathFilter pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public Configuration withNullProvider(Provider nullProvider) {
        this.nullProvider = nullProvider;
        return this;
    }

    public Configuration withFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public Configuration withFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
        return this;
    }

    public Configuration withProvider(Provider provider) {
        this.providers.add(0, provider);
        return this;
    }

    public Configuration withCaching(boolean caching) {
        this.caching = caching;
        return this;
    }

    public Configuration withCacheStart(int cacheStart) {
        this.cacheStart = cacheStart;
        return this;
    }

    public Configuration withDefaultProviders(ObjectProvider.InjectionStrategy injectionStrategy) {
        this.providers.add(new ArrayProvider());
        this.providers.add(new BigDecimalProvider());
        this.providers.add(new BooleanProvider());
        this.providers.add(new DateProvider());
        this.providers.add(new DoubleProvider());
        this.providers.add(new EnumProvider());
        this.providers.add(new FloatProvider());
        this.providers.add(new IntegerProvider());
        this.providers.add(new ListProvider());
        this.providers.add(new LocalDateProvider());
        this.providers.add(new LocalDateTimeProvider());
        this.providers.add(new LocalTimeProvider());
        this.providers.add(new ZonedDateTimeProvider());
        this.providers.add(new OffsetDateTimeProvider());
        this.providers.add(new LongProvider());
        this.providers.add(new MapProvider());
        this.providers.add(new SetProvider());
        this.providers.add(new StringProvider());
        this.providers.add(new ByteProvider());
        this.providers.add(new CharProvider());
        this.providers.add(new InterfaceProxyProvider());
        this.providers.add(new ObjectProvider(injectionStrategy));
        this.providers.add(new NullProvider());
        return this;
    }

    public Configuration withDefaultProviders() {
        return this.withDefaultProviders(ObjectProvider.InjectionStrategy.FIELD_INJECTION);
    }

    ObjectFactory createObjectFactory() {
        return new ObjectFactory(this.getProviders(), this.nullProvider, this.pathFilter, this.maxDepth, this.failOnError, this.failOnWarning);
    }

    private List<Provider> getProviders() {
        if (this.caching) {
            return Collections.singletonList(new CachedDataProvider(this.providers, this.cacheStart));
        }
        return this.providers;
    }
}

