/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.Build;
import com.jparams.object.builder.ObjectFactory;
import com.jparams.object.builder.issue.Issue;
import com.jparams.object.builder.issue.IssueLogger;
import com.jparams.object.builder.issue.IssueType;
import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.type.MemberType;

public class Context {
    private final Path path;
    private final ObjectFactory objectFactory;
    private final IssueLogger issueLogger;

    public Context(Path path, ObjectFactory objectFactory, IssueLogger issueLogger) {
        this.path = path;
        this.objectFactory = objectFactory;
        this.issueLogger = issueLogger;
    }

    public Path getPath() {
        return this.path;
    }

    public Object createChild(String name, MemberType memberType) {
        Path childPath = new Path(name, memberType, this.path);
        Build build = this.objectFactory.create(childPath, this.issueLogger);
        return build.get();
    }

    public void logWarning(String message) {
        this.issueLogger.log(new Issue(IssueType.WARNING, message, this.path, null));
    }

    public void logError(String message) {
        this.issueLogger.log(new Issue(IssueType.ERROR, message, this.path, null));
    }

    public void logError(String message, Exception exception) {
        this.issueLogger.log(new Issue(IssueType.ERROR, message, this.path, exception));
    }
}

