/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.Build;
import com.jparams.object.builder.Configuration;
import com.jparams.object.builder.ObjectFactory;
import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.type.MemberType;
import com.jparams.object.builder.type.MemberTypeResolver;
import com.jparams.object.builder.type.TypeReference;

public class ObjectBuilder {
    private final ObjectFactory objectFactory;

    private ObjectBuilder(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public <T> Build<T> buildInstanceOf(Class<T> clazz) {
        MemberType memberType = MemberTypeResolver.resolve(clazz);
        Path path = new Path("$", memberType, null);
        return this.objectFactory.create(path);
    }

    public <T> Build<T> buildInstanceOf(TypeReference<T> typeReference) {
        if (typeReference == null || typeReference.getPath() == null) {
            return null;
        }
        return this.objectFactory.create(typeReference.getPath());
    }

    public static ObjectBuilder withDefaultConfiguration() {
        Configuration configuration = new Configuration().withDefaultProviders();
        ObjectFactory objectFactory = configuration.createObjectFactory();
        return new ObjectBuilder(objectFactory);
    }

    public static ObjectBuilder withConfiguration(Configuration configuration) {
        ObjectFactory objectFactory = configuration.createObjectFactory();
        return new ObjectBuilder(objectFactory);
    }
}

