/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.issue;

import com.jparams.object.builder.issue.IssueType;
import com.jparams.object.builder.path.Path;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Issue {
    private final IssueType issueType;
    private final String message;
    private final Path path;
    private final Exception cause;

    public Issue(IssueType issueType, String message, Path path, Exception cause) {
        this.issueType = issueType;
        this.message = message;
        this.path = path;
        this.cause = cause;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public String getMessage() {
        return this.message;
    }

    public Path getPath() {
        return this.path;
    }

    public Exception getCause() {
        return this.cause;
    }

    public String toString() {
        String stackTrace = "";
        if (this.cause != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.cause.printStackTrace(printWriter);
            stackTrace = "\nCause:\n" + stringWriter.toString();
        }
        return String.format("%s at path: %s\nMessage: %s%s", new Object[]{this.issueType, this.path, this.message, stackTrace});
    }
}

