/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.issue;

import com.jparams.object.builder.exception.BuilderFailedException;
import com.jparams.object.builder.issue.Issue;
import com.jparams.object.builder.issue.IssueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IssueLogger {
    private final List<Issue> issues;
    private final boolean failOnError;
    private final boolean failOnWarning;

    public IssueLogger(boolean failOnError, boolean failOnWarning) {
        this.failOnError = failOnError;
        this.failOnWarning = failOnWarning;
        this.issues = new ArrayList<Issue>();
    }

    public void log(Issue issue) {
        if (issue.getIssueType() == IssueType.WARNING && this.failOnWarning) {
            throw new BuilderFailedException("ObjectBuilder failed with the WARNING [" + issue.getMessage() + "] at path [" + issue.getPath() + "]");
        }
        if (issue.getIssueType() == IssueType.ERROR && this.failOnError) {
            throw new BuilderFailedException("ObjectBuilder failed with the ERROR [" + issue.getMessage() + "] at path [" + issue.getPath() + "]");
        }
        this.issues.add(issue);
    }

    public List<Issue> getIssues() {
        return Collections.unmodifiableList(this.issues);
    }
}

