/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.path;

import com.jparams.object.builder.type.MemberType;
import java.util.Objects;

public class Path {
    private final String name;
    private final MemberType memberType;
    private final Path parent;

    public Path(String name, MemberType memberType, Path parent) {
        this.name = name;
        this.memberType = memberType;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public Path getParent() {
        return this.parent;
    }

    public int getDepth() {
        return this.parent == null ? 0 : this.parent.getDepth() + 1;
    }

    public String getLocation() {
        return this.parent == null ? this.name : this.parent.getLocation() + "." + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        return Objects.equals(this.name, path.name) && Objects.equals(this.memberType, path.memberType) && Objects.equals(this.parent, path.parent);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.memberType, this.parent);
    }

    public String toString() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.toString() + "." + this.name;
    }
}

