/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.MemberType;
import com.jparams.object.builder.type.MemberTypeResolver;
import java.lang.reflect.Array;
import java.util.Random;

public class ArrayProvider
implements Provider {
    private final Random random = new Random();

    @Override
    public boolean supports(Class<?> clazz) {
        return clazz.isArray();
    }

    public Object[] provide(Context context) {
        Class<?> componentType = context.getPath().getMemberType().getType().getComponentType();
        MemberType memberType = MemberTypeResolver.resolve(componentType);
        Object[] array = (Object[])Array.newInstance(componentType, this.randomSize());
        for (int i = 0; i < array.length; ++i) {
            array[i] = context.createChild("[" + i + "]", memberType);
        }
        return array;
    }

    private int randomSize() {
        int size = this.random.nextInt(5);
        return size > 0 ? size : 1;
    }
}

