/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.provider.Provider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CachedDataProvider
implements Provider {
    private final Map<Path, Object> cache = new HashMap<Path, Object>();
    private final List<Provider> providers;
    private final int cacheStart;

    public CachedDataProvider(List<Provider> providers, int cacheStart) {
        this.providers = new ArrayList<Provider>(providers);
        this.cacheStart = cacheStart;
    }

    @Override
    public Object provide(Context context) {
        if (!this.cache.containsKey(context.getPath()) || context.getPath().getDepth() < this.cacheStart) {
            Optional<Provider> provider = this.findSupportingProvider(context.getPath().getMemberType().getType());
            if (provider.isPresent()) {
                Object obj = provider.get().provide(context);
                this.cache.put(context.getPath(), obj);
                return obj;
            }
            return null;
        }
        return this.cache.get(context.getPath());
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.findSupportingProvider(clazz).isPresent();
    }

    private Optional<Provider> findSupportingProvider(Class<?> clazz) {
        return this.providers.stream().filter(provider -> provider.supports(clazz)).findFirst();
    }
}

