/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.MemberType;
import com.jparams.object.builder.type.MemberTypeResolver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class InterfaceProxyProvider
implements Provider {
    @Override
    public boolean supports(Class<?> clazz) {
        return clazz.isInterface();
    }

    @Override
    public Object provide(Context context) {
        ResponseBuildingInvocationHandler invocationHandler = new ResponseBuildingInvocationHandler(context);
        Class<?> type = context.getPath().getMemberType().getType();
        return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)invocationHandler);
    }

    private static class ResponseBuildingInvocationHandler
    implements InvocationHandler {
        private final Context context;

        ResponseBuildingInvocationHandler(Context context) {
            this.context = context;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            String methodName = String.format("%s(%s", method.getName(), Arrays.toString(args));
            MemberType memberType = MemberTypeResolver.resolve(method);
            if (memberType == null) {
                return null;
            }
            return this.context.createChild(methodName, memberType);
        }
    }
}

