/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.MemberType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class ListProvider
implements Provider {
    private final Random random = new Random();

    @Override
    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(List.class);
    }

    @Override
    public List<?> provide(Context context) {
        if (context.getPath().getMemberType().getGenerics().isEmpty()) {
            context.logWarning("No generics found. Could not populate List");
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        MemberType memberType = context.getPath().getMemberType().getGenerics().get(0);
        for (int i = 0; i < this.randomSize(); ++i) {
            Object child = context.createChild("[" + i + "]", memberType);
            list.add(child);
        }
        return list;
    }

    private int randomSize() {
        int size = this.random.nextInt(5);
        return size > 0 ? size : 1;
    }
}

