/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.MemberType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class MapProvider
implements Provider {
    private final Random random = new Random();

    @Override
    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(Map.class);
    }

    @Override
    public Map<?, ?> provide(Context context) {
        if (context.getPath().getMemberType().getGenerics().size() < 2) {
            context.logWarning("No generics found. Could not populate Map");
            return Collections.emptyMap();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        MemberType keyType = context.getPath().getMemberType().getGenerics().get(0);
        MemberType valueType = context.getPath().getMemberType().getGenerics().get(1);
        for (int i = 0; i < this.randomSize(); ++i) {
            Object key = context.createChild("[" + i + ".key]", keyType);
            Object value = context.createChild("[" + i + ".value]", valueType);
            map.put(key, value);
        }
        return map;
    }

    private int randomSize() {
        int size = this.random.nextInt(5);
        return size > 0 ? size : 1;
    }
}

