/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.MemberType;
import com.jparams.object.builder.type.MemberTypeResolver;
import com.jparams.object.builder.utils.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class ObjectProvider
implements Provider {
    private final InjectionStrategy injectionStrategy;

    public ObjectProvider(InjectionStrategy injectionStrategy) {
        if (injectionStrategy == null) {
            throw new IllegalArgumentException("Injection Strategy is null");
        }
        this.injectionStrategy = injectionStrategy;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.isEnum() && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    @Override
    public Object provide(Context context) {
        switch (this.injectionStrategy) {
            case FIELD_INJECTION: {
                return this.createInstanceWithFieldInjection(context);
            }
            case CONSTRUCTOR_INJECTION: {
                return this.createInstanceWithConstructor(context);
            }
        }
        context.logError("Unknown injection strategy " + (Object)((Object)this.injectionStrategy));
        return null;
    }

    private Object createInstanceWithConstructor(Context context) {
        Optional<Constructor> constructor = Arrays.stream(context.getPath().getMemberType().getType().getDeclaredConstructors()).sorted(Comparator.comparingInt(Constructor::getParameterCount)).peek(c -> c.setAccessible(true)).findFirst();
        if (constructor.isPresent()) {
            return this.createInstanceWithConstructor(context, constructor.get());
        }
        context.logError("No constructor found");
        return null;
    }

    private Object createInstanceWithConstructor(Context context, Constructor<?> constructor) {
        String name = String.format("%s(%s)", context.getPath().getMemberType().getType().getSimpleName(), this.getParametersString(constructor));
        Object[] arguments = new Object[constructor.getParameters().length];
        for (int i = 0; i < constructor.getParameters().length; ++i) {
            Parameter parameter = constructor.getParameters()[i];
            MemberType memberType = MemberTypeResolver.resolve(parameter);
            arguments[i] = context.createChild(name + "[" + i + "]", memberType);
        }
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            context.logError("Failed to construct an instance. Consider using Field Injection strategy", e);
            return null;
        }
    }

    private String getParametersString(Constructor<?> constructor) {
        return Arrays.stream(constructor.getParameters()).map(param -> param.getType().getSimpleName() + " " + param.getName()).reduce((item1, item2) -> item1 + ", " + item2).orElse("");
    }

    private Object createInstanceWithFieldInjection(Context context) {
        Class<?> type = context.getPath().getMemberType().getType();
        try {
            Object instance = ObjectUtils.createInstance(type);
            this.injectFields(instance, context);
            return instance;
        }
        catch (Exception e) {
            context.logError("Field Injection strategy failed with error. Consider using Constructor Injection strategy.", e);
            return null;
        }
    }

    private void injectFields(Object object, Context context) {
        for (Field field : ObjectUtils.getFields(object.getClass())) {
            try {
                MemberType memberType = MemberTypeResolver.resolve(field);
                Object instance = context.createChild(field.getName(), memberType);
                field.setAccessible(true);
                field.set(object, instance);
            }
            catch (Exception e) {
                context.logError("Failed to inject field [" + field.getName() + "]", e);
            }
        }
    }

    public static enum InjectionStrategy {
        CONSTRUCTOR_INJECTION,
        FIELD_INJECTION;

    }
}

