/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.MemberType;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class SetProvider
implements Provider {
    private final Random random = new Random();

    @Override
    public boolean supports(Class<?> clazz) {
        return clazz.isAssignableFrom(Set.class);
    }

    @Override
    public Set<?> provide(Context context) {
        if (context.getPath().getMemberType().getGenerics().isEmpty()) {
            context.logWarning("No generics found. Could not populate Set");
            return Collections.emptySet();
        }
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        MemberType memberType = context.getPath().getMemberType().getGenerics().get(0);
        for (int i = 0; i < this.randomSize(); ++i) {
            Object child = context.createChild("[" + i + "]", memberType);
            list.add(child);
        }
        return list;
    }

    private int randomSize() {
        int size = this.random.nextInt(5);
        return size > 0 ? size : 1;
    }
}

