/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MemberType {
    private final Class<?> type;
    private final List<MemberType> generics;

    public MemberType(Class<?> type) {
        this.type = type;
        this.generics = Collections.emptyList();
    }

    public MemberType(Class<?> type, List<MemberType> generics) {
        this.type = type;
        this.generics = generics == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<MemberType>(generics));
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<MemberType> getGenerics() {
        return this.generics;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MemberType)) {
            return false;
        }
        MemberType that = (MemberType)other;
        return Objects.equals(this.type, that.type) && Objects.equals(this.generics, that.generics);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.generics);
    }
}

