/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.type;

import com.jparams.object.builder.type.MemberType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MemberTypeResolver {
    private MemberTypeResolver() {
    }

    public static MemberType resolve(Method method) {
        if (method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        return MemberTypeResolver.resolve(method.getGenericReturnType());
    }

    public static MemberType resolve(Field field) {
        return MemberTypeResolver.resolve(field.getGenericType());
    }

    public static MemberType resolve(Parameter parameter) {
        return MemberTypeResolver.resolve(parameter.getParameterizedType());
    }

    public static MemberType resolve(Type type) {
        if (type instanceof ParameterizedType) {
            return MemberTypeResolver.resolve((ParameterizedType)type);
        }
        if (type instanceof Class) {
            return new MemberType((Class)type);
        }
        return null;
    }

    private static MemberType resolve(ParameterizedType parameterizedType) {
        Type type = parameterizedType.getRawType();
        List<MemberType> generics = Arrays.stream(parameterizedType.getActualTypeArguments()).map(MemberTypeResolver::resolve).filter(Objects::nonNull).collect(Collectors.toList());
        return new MemberType((Class)type, generics);
    }
}

