/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import sun.misc.Unsafe;

public final class ObjectUtils {
    private static Unsafe unsafe;

    private ObjectUtils() {
    }

    public static <T> T createInstance(Class<T> clazz) {
        if (unsafe == null) {
            throw new UnsupportedOperationException("Failed to create an instance without constructor injection");
        }
        try {
            return (T)unsafe.allocateInstance(clazz);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException("Failed to create an instance without constructor injection", e);
        }
    }

    public static List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            unsafe = null;
        }
    }
}

