/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.BuildStrategy;
import com.jparams.object.builder.ObjectFactory;
import com.jparams.object.builder.path.PathFilter;
import com.jparams.object.builder.provider.AnyValueTypeProvider;
import com.jparams.object.builder.provider.ArrayProvider;
import com.jparams.object.builder.provider.BigDecimalProvider;
import com.jparams.object.builder.provider.BooleanProvider;
import com.jparams.object.builder.provider.ByteProvider;
import com.jparams.object.builder.provider.CachingProvider;
import com.jparams.object.builder.provider.CharProvider;
import com.jparams.object.builder.provider.ConcurrentMapProvider;
import com.jparams.object.builder.provider.DateProvider;
import com.jparams.object.builder.provider.DequeProvider;
import com.jparams.object.builder.provider.DoubleProvider;
import com.jparams.object.builder.provider.EnumProvider;
import com.jparams.object.builder.provider.FloatProvider;
import com.jparams.object.builder.provider.IntegerProvider;
import com.jparams.object.builder.provider.InterfaceProvider;
import com.jparams.object.builder.provider.ListProvider;
import com.jparams.object.builder.provider.LocalDateProvider;
import com.jparams.object.builder.provider.LocalDateTimeProvider;
import com.jparams.object.builder.provider.LocalTimeProvider;
import com.jparams.object.builder.provider.LongProvider;
import com.jparams.object.builder.provider.MapProvider;
import com.jparams.object.builder.provider.NullProvider;
import com.jparams.object.builder.provider.ObjectProvider;
import com.jparams.object.builder.provider.OffsetDateTimeProvider;
import com.jparams.object.builder.provider.PrefabValueProvider;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.provider.QueueProvider;
import com.jparams.object.builder.provider.SetProvider;
import com.jparams.object.builder.provider.SortedMapProvider;
import com.jparams.object.builder.provider.SortedSetProvider;
import com.jparams.object.builder.provider.StringProvider;
import com.jparams.object.builder.provider.VectorProvider;
import com.jparams.object.builder.provider.ZonedDateTimeProvider;
import com.jparams.object.builder.type.Type;
import com.jparams.object.builder.type.TypeMap;
import com.jparams.object.builder.type.TypeSet;
import com.jparams.object.builder.util.Assertion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public final class Configuration {
    private final List<Provider> providers = new ArrayList<Provider>();
    private final TypeMap<Object> prefabValueMap = new TypeMap();
    private final TypeMap<BuildStrategy> buildStrategyMap = new TypeMap();
    private BuildStrategy defaultBuildStrategy = BuildStrategy.AUTO;
    private PathFilter pathFilter = path -> true;
    private Provider nullProvider = new NullProvider();
    private int maxDepth = 15;
    private Predicate<Type<?>> cachePredicate = type -> false;
    private boolean failOnError = false;
    private boolean failOnWarning = false;

    private Configuration() {
    }

    public Configuration withMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    public Configuration withPathFilter(PathFilter pathFilter) {
        this.pathFilter = Assertion.ifNotNull(pathFilter);
        return this;
    }

    public <T extends AnyValueTypeProvider> Configuration withNullProvider(T nullProvider) {
        this.nullProvider = Assertion.ifNotNull(nullProvider);
        return this;
    }

    public Configuration withFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
        return this;
    }

    public Configuration withFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
        return this;
    }

    public Configuration withProvider(Provider provider) {
        this.providers.add(Assertion.ifNotNull(provider));
        return this;
    }

    public Configuration withCacheAll() {
        this.cachePredicate = type -> true;
        return this;
    }

    public Configuration withCachingOnly(Type<?> ... types) {
        return this.withCachingOnly(Arrays.asList(types));
    }

    public Configuration withCachingOnly(Collection<Type<?>> types) {
        TypeSet set = new TypeSet(types);
        return this.withCaching(set::contains);
    }

    public Configuration withCachingAllExcluding(Type<?> ... types) {
        return this.withCachingAllExcluding(Arrays.asList(types));
    }

    public Configuration withCachingAllExcluding(Collection<Type<?>> types) {
        TypeSet set = new TypeSet(types);
        return this.withCaching(type -> !set.contains((Type<?>)type));
    }

    public Configuration withCaching(Predicate<Type<?>> predicate) {
        this.cachePredicate = predicate;
        return this;
    }

    public Configuration withPrefabValue(Type<?> type, Object value) {
        this.prefabValueMap.put(Assertion.ifNotNull(type), value);
        return this;
    }

    public Configuration withDefaultBuildStrategy(BuildStrategy defaultBuildStrategy) {
        this.defaultBuildStrategy = Assertion.ifNotNull(defaultBuildStrategy);
        return this;
    }

    public Configuration withBuildStrategy(Type<?> type, BuildStrategy buildStrategy) {
        this.buildStrategyMap.put(Assertion.ifNotNull(type), Assertion.ifNotNull(buildStrategy));
        return this;
    }

    ObjectFactory buildObjectFactory() {
        return new ObjectFactory(this.buildProviders(), this.nullProvider, this.pathFilter, this.maxDepth, this.failOnError, this.failOnWarning);
    }

    private List<Provider> buildProviders() {
        ArrayList<Provider> providers = new ArrayList<Provider>(this.providers);
        providers.addAll(Configuration.getDefaultProviders());
        providers.add(0, new PrefabValueProvider(this.prefabValueMap));
        providers.add(new ObjectProvider(this.defaultBuildStrategy, this.buildStrategyMap));
        providers.add(this.nullProvider);
        return Collections.singletonList(new CachingProvider(providers, this.cachePredicate));
    }

    private static List<Provider> getDefaultProviders() {
        ArrayList<Provider> providers = new ArrayList<Provider>();
        providers.add(new ArrayProvider());
        providers.add(new BigDecimalProvider());
        providers.add(new BooleanProvider());
        providers.add(new DateProvider());
        providers.add(new DoubleProvider());
        providers.add(new EnumProvider());
        providers.add(new FloatProvider());
        providers.add(new IntegerProvider());
        providers.add(new ListProvider());
        providers.add(new LocalDateProvider());
        providers.add(new LocalDateTimeProvider());
        providers.add(new LocalTimeProvider());
        providers.add(new ZonedDateTimeProvider());
        providers.add(new OffsetDateTimeProvider());
        providers.add(new LongProvider());
        providers.add(new MapProvider());
        providers.add(new SortedMapProvider());
        providers.add(new ConcurrentMapProvider());
        providers.add(new SetProvider());
        providers.add(new QueueProvider());
        providers.add(new DequeProvider());
        providers.add(new VectorProvider());
        providers.add(new SortedSetProvider());
        providers.add(new StringProvider());
        providers.add(new ByteProvider());
        providers.add(new CharProvider());
        providers.add(new InterfaceProvider());
        return providers;
    }

    public static Configuration defaultConfiguration() {
        return new Configuration();
    }
}

