/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder;

import com.jparams.object.builder.Build;
import com.jparams.object.builder.Configuration;
import com.jparams.object.builder.ObjectFactory;
import com.jparams.object.builder.path.Path;
import com.jparams.object.builder.type.Type;
import com.jparams.object.builder.type.TypeReference;
import com.jparams.object.builder.type.TypeResolver;
import com.jparams.object.builder.util.Assertion;

public class ObjectBuilder {
    private final ObjectFactory objectFactory;

    private ObjectBuilder(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public <T> Build<T> buildInstanceOf(Class<T> clazz) {
        Type<?> type = TypeResolver.resolveType(Assertion.ifNotNull(clazz));
        Path path = new Path("$", type, null);
        return this.objectFactory.create(path);
    }

    public <T> Build<T> buildInstanceOf(TypeReference<T> typeReference) {
        return this.buildInstanceOf(Assertion.ifNotNull(typeReference).getType());
    }

    public <T, R extends T> Build<R> buildInstanceOf(Type<T> type) {
        Path path = new Path("$", Assertion.ifNotNull(type), null);
        return this.objectFactory.create(path);
    }

    public static ObjectBuilder withDefaultConfiguration() {
        return ObjectBuilder.withConfiguration(Configuration.defaultConfiguration());
    }

    public static ObjectBuilder withConfiguration(Configuration configuration) {
        return new ObjectBuilder(configuration.buildObjectFactory());
    }
}

