/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import com.jparams.object.builder.utils.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class CachingProvider
implements Provider {
    private final Map<Type, Object> cache = new HashMap<Type, Object>();
    private final List<Provider> providers;
    private final Predicate<Type<?>> cachePredicate;

    public CachingProvider(List<Provider> providers, Predicate<Type<?>> cachePredicate) {
        this.providers = CollectionUtils.unmodifiableCopy(providers);
        this.cachePredicate = cachePredicate;
    }

    @Override
    public synchronized Object provide(Context context) {
        Type<?> type = context.getPath().getType();
        if (!this.cachePredicate.test(type)) {
            return this.getObject(context, type);
        }
        if (this.cache.containsKey(type)) {
            return this.cache.get(type);
        }
        Object value = this.getObject(context, type);
        this.cache.put(type, value);
        return value;
    }

    @Override
    public boolean supports(Type<?> type) {
        return this.findSupportingProvider(type).isPresent();
    }

    private Object getObject(Context context, Type<?> type) {
        return this.findSupportingProvider(type).map(provider -> provider.provide(context)).orElse(null);
    }

    private Optional<Provider> findSupportingProvider(Type<?> type) {
        return this.providers.stream().filter(provider -> provider.supports(type)).findFirst();
    }
}

