/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentMapProvider
implements Provider {
    @Override
    public boolean supports(Type<?> type) {
        return type.getJavaType().isAssignableFrom(ConcurrentMap.class);
    }

    @Override
    public ConcurrentMap<?, ?> provide(Context context) {
        ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap<Object, Object>();
        if (context.getPath().getType().getGenerics().size() < 2) {
            context.logWarning("No generics found. Could not populate Map");
            return map;
        }
        Type<?> keyType = context.getPath().getType().getGenerics().get(0).getType();
        Type<?> valueType = context.getPath().getType().getGenerics().get(1).getType();
        Object key = context.createChild("[0.key]", keyType);
        Object value = context.createChild("[0.value]", valueType);
        map.put(key, value);
        return map;
    }
}

