/*
 * Decompiled with CFR 0.152.
 */
package com.jparams.object.builder.provider;

import com.jparams.object.builder.Context;
import com.jparams.object.builder.provider.Provider;
import com.jparams.object.builder.type.Type;
import java.util.Random;

public class EnumProvider
implements Provider {
    private final Random random = new Random();

    @Override
    public boolean supports(Type<?> type) {
        return type.getJavaType().isEnum();
    }

    @Override
    public Enum provide(Context context) {
        Class<?> type = context.getPath().getType().getJavaType();
        int valueCount = type.getEnumConstants().length;
        if (valueCount > 0) {
            int index = this.random.nextInt(valueCount);
            return (Enum)type.getEnumConstants()[index];
        }
        return null;
    }
}

